package cn.openjava.basic.format.exception;

import cn.openjava.basic.format.message.IComplexMessage;
import cn.openjava.basic.format.message.IMessage;
import cn.openjava.basic.format.message.MessageType;
import lombok.Getter;
import org.springframework.http.HttpStatus;

import java.text.MessageFormat;

@Getter
public class BaseException extends RuntimeException {
    /**
     * 错误码
     */
    private final int code;
    /**
     * 错误描述
     */
    private final String message;
    /**
     * 消息类型
     */
    private MessageType type = MessageType.WARNING;

    /**
     * http状态码
     */
    private HttpStatus httpStatus = HttpStatus.OK;

    /**
     * 构造方法
     *
     * @param message 编码
     * @param fillStr 文本
     */
    public BaseException(IMessage message, Object... fillStr) {
        this.type = message.type();
        this.code = message.code();
        this.message = MessageFormat.format(message.message(), fillStr);
    }

    public BaseException(IComplexMessage message, Object... fillStr) {
        this.httpStatus = message.httpStatus();
        this.type = message.type();
        this.code = message.code();
        this.message = MessageFormat.format(message.message(), fillStr);
    }

    /**
     * 构造方法
     *
     * @param code    编码
     * @param message 信息
     */
    public BaseException(final int code, final String message) {
        this.code = code;
        this.message = message;
    }

    public BaseException(final MessageType type, final int code, final String message) {
        this.type = type;
        this.code = code;
        this.message = message;
    }

}
