/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.model.facerec;

import ai.djl.MalformedModelException;
import ai.djl.engine.Engine;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.ndarray.NDManager;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ZooModel;
import cn.smartjavaai.common.entity.DetectionInfo;
import cn.smartjavaai.common.entity.DetectionRectangle;
import cn.smartjavaai.common.entity.DetectionResponse;
import cn.smartjavaai.common.entity.R;
import cn.smartjavaai.common.entity.face.FaceInfo;
import cn.smartjavaai.common.entity.face.FaceSearchResult;
import cn.smartjavaai.common.pool.PredictorFactory;
import cn.smartjavaai.common.utils.FileUtils;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.common.utils.OpenCVUtils;
import cn.smartjavaai.face.config.FaceDetConfig;
import cn.smartjavaai.face.config.FaceRecConfig;
import cn.smartjavaai.face.entity.FaceRegisterInfo;
import cn.smartjavaai.face.entity.FaceSearchParams;
import cn.smartjavaai.face.enums.FaceDetModelEnum;
import cn.smartjavaai.face.enums.SimilarityType;
import cn.smartjavaai.face.exception.FaceException;
import cn.smartjavaai.face.factory.FaceDetModelFactory;
import cn.smartjavaai.face.model.facedect.FaceDetModel;
import cn.smartjavaai.face.model.facerec.FaceRecModel;
import cn.smartjavaai.face.model.facerec.criteria.FaceRecCriteriaFactory;
import cn.smartjavaai.face.preprocess.DJLImagePreprocessor;
import cn.smartjavaai.face.utils.FaceUtils;
import cn.smartjavaai.face.utils.SimilarityUtil;
import cn.smartjavaai.face.vector.config.MilvusConfig;
import cn.smartjavaai.face.vector.config.SQLiteConfig;
import cn.smartjavaai.face.vector.core.VectorDBClient;
import cn.smartjavaai.face.vector.core.VectorDBFactory;
import cn.smartjavaai.face.vector.entity.FaceVector;
import cn.smartjavaai.face.vector.exception.VectorDBException;
import io.milvus.param.MetricType;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.opencv.core.Mat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonFaceRecModel
implements FaceRecModel {
    private static final Logger log = LoggerFactory.getLogger(CommonFaceRecModel.class);
    private static final int DIMENSION = 512;
    private static volatile boolean isLoadCompleted = false;
    private GenericObjectPool<Predictor<Image, float[]>> predictorPool;
    private ZooModel<Image, float[]> model;
    private FaceRecConfig config;
    public static final boolean NORMALIZE_SIMILARITY = true;
    private VectorDBClient vectorDBClient;

    @Override
    public void loadModel(FaceRecConfig config) {
        if (Objects.isNull((Object)config)) {
            throw new FaceException("config\u4e3anull");
        }
        if (Objects.isNull(config.getDetectModel())) {
            config.setDetectModel(this.getDefaultDetModel());
        }
        this.config = config;
        Criteria<Image, float[]> faceFeatureCriteria = FaceRecCriteriaFactory.createCriteria(config);
        try {
            this.model = faceFeatureCriteria.loadModel();
            this.predictorPool = new GenericObjectPool((PooledObjectFactory)new PredictorFactory(this.model));
            int predictorPoolSize = config.getPredictorPoolSize();
            if (config.getPredictorPoolSize() <= 0) {
                predictorPoolSize = Runtime.getRuntime().availableProcessors();
            }
            this.predictorPool.setMaxTotal(predictorPoolSize);
            log.debug("\u5f53\u524d\u8bbe\u5907: " + this.model.getNDManager().getDevice());
            log.debug("\u5f53\u524d\u5f15\u64ce: " + Engine.getInstance().getEngineName());
            log.debug("\u6a21\u578b\u63a8\u7406\u5668\u7ebf\u7a0b\u6c60\u6700\u5927\u6570\u91cf: " + predictorPoolSize);
        }
        catch (MalformedModelException | ModelNotFoundException | IOException e) {
            throw new FaceException("\u6a21\u578b\u52a0\u8f7d\u5931\u8d25", e);
        }
        if (config.getVectorDBConfig() != null && config.getVectorDBConfig().getType() != null) {
            SQLiteConfig sqliteConfig;
            if (config.getVectorDBConfig() instanceof MilvusConfig) {
                MilvusConfig milvusConfig = (MilvusConfig)config.getVectorDBConfig();
                milvusConfig.setDimension(512);
                if (Objects.isNull(milvusConfig.getMetricType())) {
                    milvusConfig.setMetricType(MetricType.IP);
                }
            } else if (config.getVectorDBConfig() instanceof SQLiteConfig && Objects.isNull((Object)(sqliteConfig = (SQLiteConfig)config.getVectorDBConfig()).getSimilarityType())) {
                sqliteConfig.setSimilarityType(SimilarityType.IP);
            }
            this.vectorDBClient = VectorDBFactory.createClient(config.getVectorDBConfig());
            if (config.isAutoLoadFace()) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            log.debug("start load face...");
                            CommonFaceRecModel.this.vectorDBClient.initialize();
                            isLoadCompleted = true;
                            log.debug("Load face success!");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }).start();
            }
        }
    }

    public float[] featureExtraction(Image image) {
        Predictor predictor = null;
        try {
            predictor = (Predictor)this.predictorPool.borrowObject();
            float[] fArray = (float[])predictor.predict((Object)image);
            return fArray;
        }
        catch (Exception e) {
            throw new FaceException("\u4eba\u8138\u7279\u5f81\u63d0\u53d6\u9519\u8bef", e);
        }
        finally {
            if (predictor != null) {
                try {
                    this.predictorPool.returnObject((Object)predictor);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                    try {
                        predictor.close();
                    }
                    catch (Exception ex) {
                        log.error("\u5173\u95edPredictor\u5931\u8d25", (Throwable)ex);
                    }
                }
            }
        }
    }

    @Override
    public float calculSimilar(float[] feature1, float[] feature2) {
        return SimilarityUtil.calculate(feature1, feature2, SimilarityType.IP, true);
    }

    @Override
    public R<Float> featureComparison(String imagePath1, String imagePath2) {
        if (!FileUtils.isFileExists((String)imagePath1) || !FileUtils.isFileExists((String)imagePath2)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        BufferedImage image1 = null;
        BufferedImage image2 = null;
        try {
            image1 = ImageIO.read(new File(Paths.get(imagePath1, new String[0]).toAbsolutePath().toString()));
            image2 = ImageIO.read(new File(Paths.get(imagePath2, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.featureComparison(image1, image2);
    }

    @Override
    public R<Float> featureComparison(BufferedImage sourceImage1, BufferedImage sourceImag2) {
        if (!ImageUtils.isImageValid((BufferedImage)sourceImage1) || !ImageUtils.isImageValid((BufferedImage)sourceImag2)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        R<float[]> feature1 = this.extractTopFaceFeature(sourceImage1);
        if (!feature1.isSuccess()) {
            return R.fail((Integer)feature1.getCode(), (String)feature1.getMessage());
        }
        R<float[]> feature2 = this.extractTopFaceFeature(sourceImag2);
        if (!feature2.isSuccess()) {
            return R.fail((Integer)feature2.getCode(), (String)feature2.getMessage());
        }
        float ret = this.calculSimilar((float[])feature1.getData(), (float[])feature2.getData());
        return R.ok((Object)Float.valueOf(ret));
    }

    @Override
    public R<Float> featureComparison(byte[] imageData1, byte[] imageData2) {
        if (Objects.isNull(imageData1) || Objects.isNull(imageData2)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        try {
            BufferedImage bufferedImage1 = ImageIO.read(new ByteArrayInputStream(imageData1));
            BufferedImage bufferedImage2 = ImageIO.read(new ByteArrayInputStream(imageData2));
            return this.featureComparison(bufferedImage1, bufferedImage2);
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    private FaceDetModel getDefaultDetModel() {
        FaceDetConfig detectModelConfig = new FaceDetConfig();
        detectModelConfig.setModelEnum(FaceDetModelEnum.ULTRA_LIGHT_FAST_GENERIC_FACE);
        detectModelConfig.setConfidenceThreshold(0.98);
        log.debug("\u521b\u5efa\u9ed8\u8ba4\u4eba\u8138\u68c0\u6d4b\u6a21\u578b\uff1aULTRA_LIGHT_FAST_GENERIC_FACE");
        FaceDetModel detectModel = FaceDetModelFactory.getInstance().getModel(detectModelConfig);
        return detectModel;
    }

    @Override
    public R<DetectionResponse> extractFeatures(BufferedImage image) {
        R<DetectionResponse> detectedResult = this.config.getDetectModel().detect(image);
        if (!detectedResult.isSuccess()) {
            return detectedResult;
        }
        if (Objects.isNull(detectedResult.getData()) || Objects.isNull(((DetectionResponse)detectedResult.getData()).getDetectionInfoList()) || ((DetectionResponse)detectedResult.getData()).getDetectionInfoList().isEmpty()) {
            return R.fail((R.Status)R.Status.NO_FACE_DETECTED);
        }
        Image djlImage = ImageFactory.getInstance().fromImage((Object)OpenCVUtils.image2Mat((BufferedImage)image));
        try (NDManager manager = this.model.getNDManager().newSubManager();){
            DJLImagePreprocessor djlImagePreprocessor = new DJLImagePreprocessor(djlImage, manager);
            for (DetectionInfo detectionInfo : ((DetectionResponse)detectedResult.getData()).getDetectionInfoList()) {
                DetectionRectangle rectangle = detectionInfo.getDetectionRectangle();
                FaceInfo faceInfo = detectionInfo.getFaceInfo();
                float[] features = null;
                Image subImage = djlImage;
                if (this.config.isAlign()) {
                    double[][] pointsArray = FaceUtils.facePoints(faceInfo.getKeyPoints());
                    djlImagePreprocessor.enableCrop(rectangle).enableAffine(pointsArray, 96, 112);
                    subImage = djlImagePreprocessor.process();
                } else {
                    djlImagePreprocessor.enableCrop(rectangle);
                    if (this.config.isCropFace()) {
                        subImage = djlImagePreprocessor.process();
                    }
                }
                features = this.featureExtraction(subImage);
                faceInfo.setFeature(features);
            }
        }
        ((Mat)djlImage.getWrappedImage()).release();
        return detectedResult;
    }

    @Override
    public R<DetectionResponse> extractFeatures(byte[] imageData) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        try {
            return this.extractFeatures(ImageIO.read(new ByteArrayInputStream(imageData)));
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public R<DetectionResponse> extractFeatures(String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.extractFeatures(image);
    }

    @Override
    public R<float[]> extractTopFaceFeature(BufferedImage image) {
        R<DetectionResponse> detectedResult = this.config.getDetectModel().detect(image);
        if (!detectedResult.isSuccess()) {
            return R.fail((Integer)detectedResult.getCode(), (String)detectedResult.getMessage());
        }
        if (Objects.isNull(detectedResult.getData()) || Objects.isNull(((DetectionResponse)detectedResult.getData()).getDetectionInfoList()) || ((DetectionResponse)detectedResult.getData()).getDetectionInfoList().isEmpty()) {
            return R.fail((R.Status)R.Status.NO_FACE_DETECTED);
        }
        Image djlImage = ImageFactory.getInstance().fromImage((Object)OpenCVUtils.image2Mat((BufferedImage)image));
        float[] features = null;
        try (NDManager manager = this.model.getNDManager().newSubManager();){
            DJLImagePreprocessor djlImagePreprocessor = new DJLImagePreprocessor(djlImage, manager);
            DetectionInfo detectionInfo = (DetectionInfo)((DetectionResponse)detectedResult.getData()).getDetectionInfoList().get(0);
            DetectionRectangle rectangle = detectionInfo.getDetectionRectangle();
            FaceInfo faceInfo = detectionInfo.getFaceInfo();
            Image subImage = djlImage;
            if (this.config.isAlign()) {
                double[][] pointsArray = FaceUtils.facePoints(faceInfo.getKeyPoints());
                djlImagePreprocessor.enableCrop(rectangle).enableAffine(pointsArray, 96, 112);
                subImage = djlImagePreprocessor.process();
            } else {
                djlImagePreprocessor.enableCrop(rectangle);
                if (this.config.isCropFace()) {
                    subImage = djlImagePreprocessor.process();
                }
            }
            features = this.featureExtraction(subImage);
        }
        ((Mat)djlImage.getWrappedImage()).release();
        return Objects.isNull(features) ? R.fail((R.Status)R.Status.Unknown) : R.ok((Object)features);
    }

    @Override
    public R<float[]> extractTopFaceFeature(String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.extractTopFaceFeature(image);
    }

    @Override
    public R<float[]> extractTopFaceFeature(byte[] imageData) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        try {
            return this.extractTopFaceFeature(ImageIO.read(new ByteArrayInputStream(imageData)));
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public R<String> register(FaceRegisterInfo faceRegisterInfo, String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.register(faceRegisterInfo, bufferedImage);
    }

    @Override
    public R<String> register(FaceRegisterInfo faceRegisterInfo, BufferedImage sourceImage) {
        if (this.vectorDBClient == null) {
            throw new VectorDBException("\u5411\u91cf\u6570\u636e\u5e93\u672a\u521d\u59cb\u5316\u6210\u529f");
        }
        R<float[]> featureResponse = this.extractTopFaceFeature(sourceImage);
        if (!featureResponse.isSuccess()) {
            return R.fail((Integer)featureResponse.getCode(), (String)featureResponse.getMessage());
        }
        return this.register(faceRegisterInfo, (float[])featureResponse.getData());
    }

    @Override
    public R<String> register(FaceRegisterInfo faceRegisterInfo, InputStream inputStream) {
        if (Objects.isNull(inputStream)) {
            throw new FaceException("\u56fe\u50cf\u8f93\u5165\u6d41\u65e0\u6548");
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(inputStream);
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8f93\u5165\u6d41", e);
        }
        return this.register(faceRegisterInfo, image);
    }

    @Override
    public R<String> register(FaceRegisterInfo faceRegisterInfo, byte[] imageData) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        try {
            return this.register(faceRegisterInfo, ImageIO.read(new ByteArrayInputStream(imageData)));
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public R<String> register(FaceRegisterInfo faceRegisterInfo, float[] feature) {
        if (this.vectorDBClient == null) {
            return R.fail((Integer)1000, (String)"\u5411\u91cf\u6570\u636e\u5e93\u672a\u521d\u59cb\u5316\u6210\u529f");
        }
        if (Objects.isNull(feature)) {
            return R.fail((Integer)R.Status.PARAM_ERROR.getCode(), (String)"\u4eba\u8138\u7279\u5f81\u4e3a\u7a7a");
        }
        FaceVector faceVector = new FaceVector();
        if (faceRegisterInfo != null) {
            faceVector.setId(faceRegisterInfo.getId());
            faceVector.setMetadata(faceRegisterInfo.getMetadata());
        }
        faceVector.setVector(feature);
        return R.ok((Object)this.vectorDBClient.insert(faceVector));
    }

    @Override
    public void removeRegister(String ... keys) {
        this.vectorDBClient.deleteBatch(Arrays.asList(keys));
    }

    @Override
    public void clearFace() {
        if (this.vectorDBClient == null) {
            throw new VectorDBException("\u5411\u91cf\u6570\u636e\u5e93\u672a\u521d\u59cb\u5316\u6210\u529f");
        }
        this.vectorDBClient.dropCollection("face");
    }

    @Override
    public void upsertFace(FaceRegisterInfo faceRegisterInfo, String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            throw new FaceException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        this.upsertFace(faceRegisterInfo, bufferedImage);
    }

    @Override
    public void upsertFace(FaceRegisterInfo faceRegisterInfo, BufferedImage sourceImage) {
        if (this.vectorDBClient == null) {
            throw new VectorDBException("\u5411\u91cf\u6570\u636e\u5e93\u672a\u521d\u59cb\u5316\u6210\u529f");
        }
        if (Objects.isNull(faceRegisterInfo)) {
            throw new FaceException("\u6ce8\u518c\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)faceRegisterInfo.getId())) {
            throw new FaceException("\u6ce8\u518c\u4fe1\u606f\u4e2dID\u4e3a\u7a7a");
        }
        R<float[]> featureResponse = this.extractTopFaceFeature(sourceImage);
        if (!featureResponse.isSuccess()) {
            throw new FaceException(featureResponse.getMessage());
        }
        this.upsertFace(faceRegisterInfo, (float[])featureResponse.getData());
    }

    @Override
    public void upsertFace(FaceRegisterInfo faceRegisterInfo, float[] feature) {
        if (Objects.isNull(feature)) {
            throw new FaceException("\u4eba\u8138\u7279\u5f81\u4e3a\u7a7a");
        }
        if (Objects.isNull(this.vectorDBClient)) {
            throw new FaceException("\u672a\u521d\u59cb\u5316\u4eba\u8138\u5e93");
        }
        FaceVector faceVector = new FaceVector();
        if (faceRegisterInfo != null) {
            faceVector.setId(faceRegisterInfo.getId());
            faceVector.setMetadata(faceRegisterInfo.getMetadata());
        }
        faceVector.setVector(feature);
        this.vectorDBClient.upsert(faceVector);
    }

    @Override
    public void upsertFace(FaceRegisterInfo faceRegisterInfo, byte[] imageData) {
        if (Objects.isNull(imageData)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        try {
            this.upsertFace(faceRegisterInfo, ImageIO.read(new ByteArrayInputStream(imageData)));
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public R<List<FaceSearchResult>> searchByTopFace(String imagePath, FaceSearchParams params) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.searchByTopFace(bufferedImage, params);
    }

    @Override
    public R<List<FaceSearchResult>> searchByTopFace(byte[] imageData, FaceSearchParams params) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        try {
            return this.searchByTopFace(ImageIO.read(new ByteArrayInputStream(imageData)), params);
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public R<List<FaceSearchResult>> searchByTopFace(BufferedImage sourceImage, FaceSearchParams params) {
        if (this.vectorDBClient == null) {
            return R.fail((Integer)1000, (String)"\u5411\u91cf\u6570\u636e\u5e93\u672a\u521d\u59cb\u5316\u6210\u529f");
        }
        R<float[]> featureResponse = this.extractTopFaceFeature(sourceImage);
        if (!featureResponse.isSuccess()) {
            return R.fail((Integer)featureResponse.getCode(), (String)featureResponse.getMessage());
        }
        return R.ok(this.search((float[])featureResponse.getData(), params));
    }

    @Override
    public List<FaceSearchResult> search(float[] feature, FaceSearchParams params) {
        if (this.vectorDBClient == null) {
            throw new VectorDBException("\u5411\u91cf\u6570\u636e\u5e93\u672a\u521d\u59cb\u5316\u6210\u529f");
        }
        if (Objects.isNull(feature)) {
            throw new FaceException("\u4eba\u8138\u7279\u5f81\u4e3a\u7a7a");
        }
        if (Objects.isNull(params)) {
            throw new FaceException("\u4eba\u8138\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a");
        }
        float threshold = Objects.isNull(params.getThreshold()) ? 0.8f : params.getThreshold().floatValue();
        int topK = Objects.isNull(params.getTopK()) ? 1 : params.getTopK();
        boolean normalize = Objects.isNull(params.getNormalizeSimilarity()) ? true : params.getNormalizeSimilarity();
        FaceSearchParams searchParams = new FaceSearchParams(topK, Float.valueOf(threshold), normalize);
        List<FaceSearchResult> searchResults = this.vectorDBClient.search(feature, searchParams);
        return searchResults;
    }

    @Override
    public R<DetectionResponse> search(String imagePath, FaceSearchParams params) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new File(Paths.get(imagePath, new String[0]).toAbsolutePath().toString()));
        }
        catch (IOException e) {
            throw new FaceException("\u65e0\u6548\u56fe\u7247\u8def\u5f84", e);
        }
        return this.search(bufferedImage, params);
    }

    @Override
    public R<DetectionResponse> search(BufferedImage sourceImage, FaceSearchParams params) {
        if (this.vectorDBClient == null) {
            throw new VectorDBException("\u5411\u91cf\u6570\u636e\u5e93\u672a\u521d\u59cb\u5316\u6210\u529f");
        }
        R<DetectionResponse> detectionResponse = this.extractFeatures(sourceImage);
        if (!detectionResponse.isSuccess()) {
            return detectionResponse;
        }
        float threshold = Objects.isNull(params.getThreshold()) ? 0.8f : params.getThreshold().floatValue();
        int topK = Objects.isNull(params.getTopK()) ? 1 : params.getTopK();
        boolean normalize = Objects.isNull(params.getNormalizeSimilarity()) ? true : params.getNormalizeSimilarity();
        FaceSearchParams searchParams = new FaceSearchParams(topK, Float.valueOf(threshold), normalize);
        for (DetectionInfo detectionInfo : ((DetectionResponse)detectionResponse.getData()).getDetectionInfoList()) {
            if (!Objects.nonNull(detectionInfo.getFaceInfo()) || !Objects.nonNull(detectionInfo.getFaceInfo().getFeature())) continue;
            List<FaceSearchResult> searchResults = this.vectorDBClient.search(detectionInfo.getFaceInfo().getFeature(), searchParams);
            detectionInfo.getFaceInfo().setFaceSearchResults(searchResults);
        }
        return detectionResponse;
    }

    @Override
    public R<DetectionResponse> search(byte[] imageData, FaceSearchParams params) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        try {
            return this.search(ImageIO.read(new ByteArrayInputStream(imageData)), params);
        }
        catch (IOException e) {
            throw new FaceException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public R<FaceVector> getFaceInfoById(String id) {
        if (this.vectorDBClient == null) {
            return R.fail((Integer)1000, (String)"\u5411\u91cf\u6570\u636e\u5e93\u672a\u521d\u59cb\u5316\u6210\u529f");
        }
        return R.ok((Object)this.vectorDBClient.getFaceInfoById(id));
    }

    @Override
    public R<List<FaceVector>> listFaces(long pageNum, long pageSize) {
        if (this.vectorDBClient == null) {
            return R.fail((Integer)1000, (String)"\u5411\u91cf\u6570\u636e\u5e93\u672a\u521d\u59cb\u5316\u6210\u529f");
        }
        return R.ok(this.vectorDBClient.listFaces(pageNum, pageSize));
    }

    @Override
    public void loadFaceFeatures() {
        if (Objects.isNull(this.vectorDBClient)) {
            throw new FaceException("\u672a\u521d\u59cb\u5316\u4eba\u8138\u5e93");
        }
        this.vectorDBClient.loadFaceFeatures();
    }

    @Override
    public void releaseFaceFeatures() {
        if (Objects.isNull(this.vectorDBClient)) {
            throw new FaceException("\u672a\u521d\u59cb\u5316\u4eba\u8138\u5e93");
        }
        this.vectorDBClient.releaseFaceFeatures();
    }

    @Override
    public void close() {
        try {
            if (this.predictorPool != null) {
                this.predictorPool.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed predictorPool \u5931\u8d25", (Throwable)e);
        }
        try {
            if (Objects.nonNull(this.vectorDBClient)) {
                this.vectorDBClient.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed vectorDBClient \u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public boolean isLoadFaceCompleted() {
        return isLoadCompleted;
    }

    @Override
    public GenericObjectPool<Predictor<Image, float[]>> getPool() {
        return this.predictorPool;
    }
}

