/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.utils;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.BoundingBox;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDManager;
import cn.smartjavaai.common.entity.DetectionInfo;
import cn.smartjavaai.common.entity.DetectionRectangle;
import cn.smartjavaai.common.entity.DetectionResponse;
import cn.smartjavaai.common.entity.Point;
import cn.smartjavaai.common.entity.face.FaceAttribute;
import cn.smartjavaai.common.entity.face.FaceInfo;
import cn.smartjavaai.common.entity.face.HeadPose;
import cn.smartjavaai.common.entity.face.LivenessResult;
import cn.smartjavaai.common.enums.face.EyeStatus;
import cn.smartjavaai.common.enums.face.GenderType;
import cn.smartjavaai.common.enums.face.LivenessStatus;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.face.exception.FaceException;
import com.seeta.sdk.EyeStateDetector;
import com.seeta.sdk.FaceAntiSpoofing;
import com.seeta.sdk.GenderPredictor;
import com.seeta.sdk.SeetaImageData;
import com.seeta.sdk.SeetaPointF;
import com.seeta.sdk.SeetaRect;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;

public class FaceUtils {
    public static DetectionResponse convertToDetectionResponse(DetectedObjects detection, Image img) {
        if (Objects.isNull(detection) || Objects.isNull(detection.getProbabilities()) || detection.getProbabilities().isEmpty() || Objects.isNull(detection.items()) || detection.items().isEmpty()) {
            return null;
        }
        DetectionResponse detectionResponse = new DetectionResponse();
        List detectedObjectList = detection.items();
        ArrayList<DetectionInfo> detectionInfoList = new ArrayList<DetectionInfo>();
        Iterator iterator = detectedObjectList.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            DetectedObjects.DetectedObject result = (DetectedObjects.DetectedObject)iterator.next();
            BoundingBox box = result.getBoundingBox();
            ArrayList keyPoints = new ArrayList();
            box.getBounds().getPath().forEach(point -> keyPoints.add(new Point(point.getX(), point.getY())));
            int x = (int)(box.getBounds().getX() * (double)img.getWidth());
            int y = (int)(box.getBounds().getY() * (double)img.getHeight());
            int width = (int)(box.getBounds().getWidth() * (double)img.getWidth());
            int height = (int)(box.getBounds().getHeight() * (double)img.getHeight());
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            if (x + width > img.getWidth()) {
                width = img.getWidth() - x;
            }
            if (y + height > img.getHeight()) {
                height = img.getHeight() - y;
            }
            DetectionRectangle rectangle = new DetectionRectangle(x, y, width, height);
            FaceInfo faceInfo = new FaceInfo(keyPoints);
            DetectionInfo detectionInfo = new DetectionInfo(rectangle, ((Double)detection.getProbabilities().get(index)).floatValue(), faceInfo);
            detectionInfoList.add(detectionInfo);
            ++index;
        }
        detectionResponse.setDetectionInfoList(detectionInfoList);
        return detectionResponse;
    }

    public static DetectionResponse convertToDetectionResponse(SeetaRect[] seetaResult, List<SeetaPointF[]> seetaPointFSList) {
        if (Objects.isNull(seetaResult) || seetaResult.length == 0) {
            return null;
        }
        DetectionResponse detectionResponse = new DetectionResponse();
        ArrayList<DetectionInfo> detectionInfoList = new ArrayList<DetectionInfo>();
        for (int i = 0; i < seetaResult.length; ++i) {
            SeetaRect rect = seetaResult[i];
            SeetaPointF[] seetaPointFS = seetaPointFSList.get(i);
            DetectionRectangle rectangle = new DetectionRectangle(rect.x, rect.y, rect.width, rect.height);
            List keyPoints = Arrays.stream(seetaPointFS).map(p -> new Point(p.x, p.y)).collect(Collectors.toList());
            FaceInfo faceInfo = new FaceInfo(keyPoints);
            DetectionInfo detectionInfo = new DetectionInfo(rectangle, 0.0f, faceInfo);
            detectionInfoList.add(detectionInfo);
        }
        detectionResponse.setDetectionInfoList(detectionInfoList);
        return detectionResponse;
    }

    public static DetectionResponse featuresConvertToResponse(SeetaRect[] seetaResult, List<SeetaPointF[]> seetaPointFSList, List<float[]> featureList) {
        if (Objects.isNull(seetaResult) || seetaResult.length == 0) {
            return null;
        }
        ArrayList<DetectionInfo> detectionInfoList = new ArrayList<DetectionInfo>();
        for (int i = 0; i < seetaResult.length; ++i) {
            SeetaRect rect = seetaResult[i];
            DetectionRectangle rectangle = new DetectionRectangle(rect.x, rect.y, rect.width, rect.height);
            FaceInfo faceInfo = new FaceInfo();
            if (seetaPointFSList != null && seetaPointFSList.size() > 0) {
                SeetaPointF[] seetaPointFS = seetaPointFSList.get(i);
                List keyPoints = Arrays.stream(seetaPointFS).map(p -> new Point(p.x, p.y)).collect(Collectors.toList());
                faceInfo.setKeyPoints(keyPoints);
            }
            if (featureList != null && featureList.size() > 0) {
                faceInfo.setFeature(featureList.get(i));
            }
            detectionInfoList.add(new DetectionInfo(rectangle, 0.0f, faceInfo));
        }
        return new DetectionResponse(detectionInfoList);
    }

    public static DetectionResponse featuresConvertToResponse(SeetaRect rect, SeetaPointF[] seetaPointFS, float[] feature) {
        ArrayList<DetectionInfo> detectionInfoList = new ArrayList<DetectionInfo>();
        DetectionRectangle rectangle = new DetectionRectangle(rect.x, rect.y, rect.width, rect.height);
        FaceInfo faceInfo = new FaceInfo();
        List keyPoints = Arrays.stream(seetaPointFS).map(p -> new Point(p.x, p.y)).collect(Collectors.toList());
        faceInfo.setKeyPoints(keyPoints);
        faceInfo.setFeature(feature);
        detectionInfoList.add(new DetectionInfo(rectangle, 0.0f, faceInfo));
        return new DetectionResponse(detectionInfoList);
    }

    public static void drawBoundingBoxes(BufferedImage sourceImage, DetectionResponse detectionResponse, String savePath) throws IOException {
        if (!ImageUtils.isImageValid((BufferedImage)sourceImage)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        if (Objects.isNull(detectionResponse) || Objects.isNull(detectionResponse.getDetectionInfoList()) || detectionResponse.getDetectionInfoList().isEmpty()) {
            throw new FaceException("\u65e0\u76ee\u6807\u6570\u636e");
        }
        Graphics2D graphics = sourceImage.createGraphics();
        graphics.setColor(Color.RED);
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int stroke = 2;
        for (DetectionInfo detectionInfo : detectionResponse.getDetectionInfoList()) {
            DetectionRectangle rectangle = detectionInfo.getDetectionRectangle();
            graphics.setColor(Color.RED);
            graphics.drawRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
            FaceUtils.drawText(graphics, "face", rectangle.getX(), rectangle.getY(), stroke, 4);
            if (detectionInfo.getFaceInfo() == null || detectionInfo.getFaceInfo().getKeyPoints() == null || detectionInfo.getFaceInfo().getKeyPoints().isEmpty()) continue;
            FaceUtils.drawLandmarks(graphics, detectionInfo.getFaceInfo().getKeyPoints());
        }
        graphics.dispose();
        ImageIO.write((RenderedImage)sourceImage, "jpg", new File(savePath));
    }

    public static BufferedImage drawBoundingBoxes(BufferedImage sourceImage, DetectionResponse detectionResponse) throws IOException {
        if (!ImageUtils.isImageValid((BufferedImage)sourceImage)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        if (Objects.isNull(detectionResponse) || Objects.isNull(detectionResponse.getDetectionInfoList()) || detectionResponse.getDetectionInfoList().isEmpty()) {
            throw new FaceException("\u65e0\u76ee\u6807\u6570\u636e");
        }
        Graphics2D graphics = sourceImage.createGraphics();
        graphics.setColor(Color.RED);
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int stroke = 2;
        for (DetectionInfo detectionInfo : detectionResponse.getDetectionInfoList()) {
            DetectionRectangle rectangle = detectionInfo.getDetectionRectangle();
            graphics.setColor(Color.RED);
            graphics.drawRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
            FaceUtils.drawText(graphics, "face", rectangle.getX(), rectangle.getY(), stroke, 4);
            if (detectionInfo.getFaceInfo() == null || detectionInfo.getFaceInfo().getKeyPoints() == null || detectionInfo.getFaceInfo().getKeyPoints().isEmpty()) continue;
            FaceUtils.drawLandmarks(graphics, detectionInfo.getFaceInfo().getKeyPoints());
        }
        graphics.dispose();
        return sourceImage;
    }

    private static void drawText(Graphics2D g, String text, int x, int y, int stroke, int padding) {
        FontMetrics metrics = g.getFontMetrics();
        int width = metrics.stringWidth(text) + padding * 2 - stroke / 2;
        int height = metrics.getHeight() + metrics.getDescent();
        int ascent = metrics.getAscent();
        Rectangle background = new Rectangle(x += stroke / 2, y += stroke / 2, width, height);
        g.fill(background);
        g.setPaint(Color.WHITE);
        g.drawString(text, x + padding, y + ascent);
    }

    public static DetectionRectangle correctRect(DetectionRectangle rectangle, int imageWidth, int imageHeight) {
        int x = rectangle.getX();
        int y = rectangle.getY();
        int width = rectangle.getWidth();
        int height = rectangle.getHeight();
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x + width > imageWidth) {
            width = imageWidth - x;
        }
        if (y + height > imageHeight) {
            height = imageHeight - y;
        }
        if (width <= 0 || height <= 0) {
            return null;
        }
        return new DetectionRectangle(x, y, width, height);
    }

    public static double[][] facePoints(List<Point> points) {
        double[][] pointsArray = new double[5][2];
        int i = 0;
        for (Point point : points) {
            pointsArray[i][0] = point.getX();
            pointsArray[i][1] = point.getY();
            ++i;
        }
        return pointsArray;
    }

    public static double[][] facePoints(SeetaPointF[] pointFS) {
        double[][] pointsArray = new double[5][2];
        int i = 0;
        for (SeetaPointF point : pointFS) {
            pointsArray[i][0] = point.getX();
            pointsArray[i][1] = point.getY();
            ++i;
        }
        return pointsArray;
    }

    public static NDArray faceTemplate512x512(NDManager manager) {
        double[][] coord5point = new double[][]{{192.98138, 239.94708}, {318.90277, 240.1936}, {256.63416, 314.01935}, {201.26117, 371.41043}, {313.08905, 371.15118}};
        NDArray points = manager.create((double[][])coord5point);
        return points;
    }

    public static NDArray faceTemplate112x112(NDManager manager) {
        double[][] coord5point = new double[][]{{30.29459953, 51.69630051}, {65.53179932, 51.50139999}, {48.02519989, 71.73660278}, {33.54930115, 87.0}, {62.72990036, 87.0}};
        NDArray points = manager.create((double[][])coord5point);
        return points;
    }

    public static NDArray faceTemplate96x112(NDManager manager) {
        double[][] coord5point = new double[][]{{30.29459953, 51.69630051}, {65.53179932, 51.50139999}, {48.02519989, 71.73660278}, {33.54930115, 92.3655014}, {62.72990036, 92.20410156}};
        NDArray points = manager.create((double[][])coord5point);
        return points;
    }

    public static BufferedImage toBufferedImage(SeetaImageData seetaImageData) {
        int type = 5;
        BufferedImage image = new BufferedImage(seetaImageData.width, seetaImageData.height, type);
        image.getRaster().setDataElements(0, 0, seetaImageData.width, seetaImageData.height, seetaImageData.data);
        return image;
    }

    private static void drawLandmarks(Graphics2D g, List<Point> keyPoints) {
        g.setColor(new Color(246, 96, 0));
        BasicStroke bStroke = new BasicStroke(4.0f, 0, 0);
        g.setStroke(bStroke);
        for (Point point : keyPoints) {
            g.drawRect((int)point.getX(), (int)point.getY(), 2, 2);
        }
    }

    public static SeetaRect convertToSeetaRect(DetectionRectangle detectionRectangle) {
        SeetaRect seetaRect = new SeetaRect();
        seetaRect.x = detectionRectangle.getX();
        seetaRect.y = detectionRectangle.getY();
        seetaRect.width = detectionRectangle.getWidth();
        seetaRect.height = detectionRectangle.getHeight();
        return seetaRect;
    }

    public static SeetaPointF[] convertToSeetaPointF(List<Point> pointList) {
        return (SeetaPointF[])pointList.stream().map(p -> {
            SeetaPointF sp = new SeetaPointF();
            sp.x = p.getX();
            sp.y = p.getY();
            return sp;
        }).toArray(SeetaPointF[]::new);
    }

    public static LivenessStatus convertToLivenessStatus(FaceAntiSpoofing.Status status) {
        if (status == null) {
            return LivenessStatus.UNKNOWN;
        }
        switch (status) {
            case REAL: {
                return LivenessStatus.LIVE;
            }
            case SPOOF: {
                return LivenessStatus.NON_LIVE;
            }
            case FUZZY: {
                return LivenessStatus.UNKNOWN;
            }
            case DETECTING: {
                return LivenessStatus.DETECTING;
            }
        }
        return LivenessStatus.UNKNOWN;
    }

    public static GenderType convertToGenderType(GenderPredictor.GENDER gender) {
        if (gender == null) {
            return GenderType.UNKNOWN;
        }
        switch (gender) {
            case MALE: {
                return GenderType.MALE;
            }
            case FEMALE: {
                return GenderType.FEMALE;
            }
        }
        return GenderType.UNKNOWN;
    }

    public static EyeStatus convertToEyeStatus(EyeStateDetector.EYE_STATE eyeState) {
        if (eyeState == null) {
            return EyeStatus.UNKNOWN;
        }
        switch (eyeState) {
            case EYE_OPEN: {
                return EyeStatus.OPEN;
            }
            case EYE_CLOSE: {
                return EyeStatus.CLOSED;
            }
            case EYE_RANDOM: {
                return EyeStatus.NON_EYE_REGION;
            }
        }
        return EyeStatus.UNKNOWN;
    }

    public static DetectionResponse convertToFaceAttributeResponse(SeetaRect[] seetaResult, List<SeetaPointF[]> seetaPointFSList, List<FaceAttribute> faceAttributeList) {
        if (Objects.isNull(seetaResult) || seetaResult.length == 0) {
            return null;
        }
        ArrayList<DetectionInfo> detectionInfoList = new ArrayList<DetectionInfo>();
        for (int i = 0; i < seetaResult.length; ++i) {
            SeetaRect rect = seetaResult[i];
            DetectionRectangle rectangle = new DetectionRectangle(rect.x, rect.y, rect.width, rect.height);
            FaceInfo faceInfo = new FaceInfo();
            if (seetaPointFSList != null && seetaPointFSList.size() > 0) {
                SeetaPointF[] seetaPointFS = seetaPointFSList.get(i);
                List keyPoints = Arrays.stream(seetaPointFS).map(p -> new Point(p.x, p.y)).collect(Collectors.toList());
                faceInfo.setKeyPoints(keyPoints);
            }
            if (faceAttributeList != null && faceAttributeList.size() > 0) {
                faceInfo.setFaceAttribute(faceAttributeList.get(i));
            }
            detectionInfoList.add(new DetectionInfo(rectangle, 0.0f, faceInfo));
        }
        return new DetectionResponse(detectionInfoList);
    }

    public static DetectionResponse convertToDetectionResponse(SeetaRect[] seetaResult, List<SeetaPointF[]> seetaPointFSList, List<LivenessStatus> livenessStatusList) {
        if (Objects.isNull(seetaResult) || seetaResult.length == 0) {
            return null;
        }
        DetectionResponse detectionResponse = new DetectionResponse();
        ArrayList<DetectionInfo> detectionInfoList = new ArrayList<DetectionInfo>();
        for (int i = 0; i < seetaResult.length; ++i) {
            SeetaRect rect = seetaResult[i];
            SeetaPointF[] seetaPointFS = seetaPointFSList.get(i);
            DetectionRectangle rectangle = new DetectionRectangle(rect.x, rect.y, rect.width, rect.height);
            List keyPoints = Arrays.stream(seetaPointFS).map(p -> new Point(p.x, p.y)).collect(Collectors.toList());
            FaceInfo faceInfo = new FaceInfo(keyPoints);
            faceInfo.setLivenessStatus(new LivenessResult(livenessStatusList.get(i)));
            DetectionInfo detectionInfo = new DetectionInfo(rectangle, 0.0f, faceInfo);
            detectionInfoList.add(detectionInfo);
        }
        detectionResponse.setDetectionInfoList(detectionInfoList);
        return detectionResponse;
    }

    public static void drawBoxesWithFaceAttribute(BufferedImage sourceImage, DetectionResponse detectionResponse, String savePath) throws IOException {
        if (!ImageUtils.isImageValid((BufferedImage)sourceImage)) {
            throw new FaceException("\u56fe\u50cf\u65e0\u6548");
        }
        if (Objects.isNull(detectionResponse) || Objects.isNull(detectionResponse.getDetectionInfoList()) || detectionResponse.getDetectionInfoList().isEmpty()) {
            throw new FaceException("\u65e0\u76ee\u6807\u6570\u636e");
        }
        Graphics2D graphics = sourceImage.createGraphics();
        graphics.setColor(Color.RED);
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int stroke = 2;
        for (DetectionInfo detectionInfo : detectionResponse.getDetectionInfoList()) {
            DetectionRectangle rectangle = detectionInfo.getDetectionRectangle();
            graphics.setColor(Color.RED);
            graphics.drawRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
            if (detectionInfo.getFaceInfo() != null && detectionInfo.getFaceInfo().getKeyPoints() != null && !detectionInfo.getFaceInfo().getKeyPoints().isEmpty()) {
                FaceUtils.drawLandmarks(graphics, detectionInfo.getFaceInfo().getKeyPoints());
            }
            if (rectangle.getHeight() <= 60 || detectionInfo.getFaceInfo() == null || detectionInfo.getFaceInfo().getFaceAttribute() == null) continue;
            StringBuilder attrText = new StringBuilder();
            FaceAttribute faceAttribute = detectionInfo.getFaceInfo().getFaceAttribute();
            if (faceAttribute.getGenderType() != null) {
                attrText.append(faceAttribute.getGenderType().name()).append(" ");
            }
            if (faceAttribute.getAge() != null) {
                attrText.append(faceAttribute.getAge()).append("\u5c81").append(" ");
            }
            if (faceAttribute.getWearingMask() != null) {
                attrText.append(faceAttribute.getWearingMask() != false ? "\u6234\u53e3\u7f69" : "\u672a\u6234\u53e3\u7f69").append(" ");
            }
            if (faceAttribute.getLeftEyeStatus() != null && faceAttribute.getRightEyeStatus() != null) {
                attrText.append("\u773c\u775b:").append(faceAttribute.getLeftEyeStatus().name()).append("/").append(faceAttribute.getRightEyeStatus().name()).append(" ");
            }
            ArrayList<String> lines = new ArrayList<String>();
            if (faceAttribute.getGenderType() != null) {
                lines.add("\u6027\u522b: " + faceAttribute.getGenderType().name());
            }
            if (faceAttribute.getAge() != null) {
                lines.add("\u5e74\u9f84: " + faceAttribute.getAge());
            }
            if (faceAttribute.getWearingMask() != null) {
                lines.add("\u53e3\u7f69: " + (faceAttribute.getWearingMask() != false ? "\u662f" : "\u5426"));
            }
            if (faceAttribute.getLeftEyeStatus() != null && faceAttribute.getRightEyeStatus() != null) {
                lines.add("\u773c\u775b: " + faceAttribute.getLeftEyeStatus().name() + "/" + faceAttribute.getRightEyeStatus().name());
            }
            if (faceAttribute.getHeadPose() != null) {
                HeadPose pose = faceAttribute.getHeadPose();
                String pitch = pose.getPitch() != null ? String.valueOf(pose.getPitch().intValue()) : "-";
                String yaw = pose.getYaw() != null ? String.valueOf(pose.getYaw().intValue()) : "-";
                String roll = pose.getRoll() != null ? String.valueOf(pose.getRoll().intValue()) : "-";
                lines.add("\u59ff\u6001: P=" + pitch + " Y=" + yaw + " R=" + roll);
            }
            if (lines.isEmpty()) continue;
            FaceUtils.drawMultilineTextWithBackground(graphics, lines, rectangle.getX(), rectangle.getY());
        }
        graphics.dispose();
        ImageIO.write((RenderedImage)sourceImage, "jpg", new File(savePath));
    }

    private static void drawMultilineTextWithBackground(Graphics2D g, List<String> lines, int x, int y) {
        Font font = new Font("SansSerif", 0, 14);
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        int lineHeight = fm.getHeight();
        int maxWidth = lines.stream().mapToInt(fm::stringWidth).max().orElse(0);
        int padding = 4;
        int boxWidth = maxWidth + padding * 2;
        int boxHeight = lineHeight * lines.size() + padding * 2;
        g.setColor(new Color(0, 0, 0, 128));
        g.fillRoundRect(x, y, boxWidth, boxHeight, 8, 8);
        g.setColor(Color.WHITE);
        for (int i = 0; i < lines.size(); ++i) {
            g.drawString(lines.get(i), x + padding, y + padding + (i + 1) * lineHeight - 4);
        }
    }

    public static float convertScoreToSimilarity(String metricType, float score) {
        switch (metricType.toUpperCase()) {
            case "IP": {
                return (score + 1.0f) / 2.0f;
            }
            case "L2": {
                return 1.0f / (1.0f + score);
            }
            case "COSINE": {
                return (score + 1.0f) / 2.0f;
            }
        }
        throw new IllegalArgumentException("Unsupported metricType: " + metricType);
    }
}

