/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.classloader;

import cn.ujava.common.classloader.ClassLoaderUtil;
import cn.ujava.common.io.resource.Resource;
import cn.ujava.common.util.ObjUtil;
import java.security.SecureClassLoader;
import java.util.HashMap;
import java.util.Map;

public class ResourceClassLoader<T extends Resource>
extends SecureClassLoader {
    private final Map<String, T> resourceMap;
    private final Map<String, Class<?>> cacheClassMap;

    public ResourceClassLoader(ClassLoader parentClassLoader, Map<String, T> resourceMap) {
        super(ObjUtil.defaultIfNull(parentClassLoader, ClassLoaderUtil::getClassLoader));
        this.resourceMap = ObjUtil.defaultIfNull(resourceMap, HashMap::new);
        this.cacheClassMap = new HashMap();
    }

    public ResourceClassLoader<T> addResource(T resource) {
        this.resourceMap.put(resource.getName(), resource);
        return this;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class clazz = this.cacheClassMap.computeIfAbsent(name, this::defineByName);
        if (clazz == null) {
            return super.findClass(name);
        }
        return clazz;
    }

    private Class<?> defineByName(String name) {
        Resource resource = (Resource)this.resourceMap.get(name);
        if (null != resource) {
            byte[] bytes = resource.readBytes();
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        return null;
    }
}

