/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.collection;

import cn.ujava.common.collection.set.SetFromMap;
import cn.ujava.common.map.SafeConcurrentHashMap;
import java.util.Collection;

public class ConcurrentHashSet<E>
extends SetFromMap<E> {
    private static final long serialVersionUID = 7997886765361607470L;

    public ConcurrentHashSet() {
        super(new SafeConcurrentHashMap());
    }

    public ConcurrentHashSet(int initialCapacity) {
        super(new SafeConcurrentHashMap(initialCapacity));
    }

    public ConcurrentHashSet(int initialCapacity, float loadFactor) {
        super(new SafeConcurrentHashMap(initialCapacity, loadFactor));
    }

    public ConcurrentHashSet(int initialCapacity, float loadFactor, int concurrencyLevel) {
        super(new SafeConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel));
    }

    public ConcurrentHashSet(Iterable<E> iter) {
        super(iter instanceof Collection ? new SafeConcurrentHashMap(((Collection)iter).size()) : new SafeConcurrentHashMap());
        if (iter instanceof Collection) {
            this.addAll((Collection)iter);
        } else {
            for (E e : iter) {
                this.add(e);
            }
        }
    }
}

