/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.compress;

import cn.ujava.common.compress.ZipFileResource;
import cn.ujava.common.compress.ZipResource;
import cn.ujava.common.compress.ZipStreamResource;
import cn.ujava.common.compress.ZipUtil;
import cn.ujava.common.io.IORuntimeException;
import cn.ujava.common.io.IoUtil;
import cn.ujava.common.io.file.FileUtil;
import cn.ujava.common.text.StrUtil;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ZipReader
implements Closeable {
    private static final int DEFAULT_MAX_SIZE_DIFF = 100;
    private final ZipResource resource;
    private int maxSizeDiff = 100;

    public static ZipReader of(File zipFile, Charset charset) {
        return new ZipReader(ZipUtil.toZipFile(zipFile, charset));
    }

    public static ZipReader of(InputStream in, Charset charset) {
        return new ZipReader(new ZipInputStream(in, charset));
    }

    public ZipReader(ZipFile zipFile) {
        this(new ZipFileResource(zipFile));
    }

    public ZipReader(ZipInputStream zin) {
        this(new ZipStreamResource(zin));
    }

    public ZipReader(ZipResource resource) {
        this.resource = resource;
    }

    public ZipReader setMaxSizeDiff(int maxSizeDiff) {
        this.maxSizeDiff = maxSizeDiff;
        return this;
    }

    public InputStream get(String path) {
        return this.resource.get(path);
    }

    public File readTo(File outFile) throws IORuntimeException {
        return this.readTo(outFile, null);
    }

    public File readTo(File outFile, Predicate<ZipEntry> entryFilter) throws IORuntimeException {
        this.read(zipEntry -> {
            if (null == entryFilter || entryFilter.test((ZipEntry)zipEntry)) {
                this.readEntry((ZipEntry)zipEntry, outFile);
            }
        });
        return outFile;
    }

    public ZipReader read(Consumer<ZipEntry> consumer) throws IORuntimeException {
        this.resource.read(consumer, this.maxSizeDiff);
        return this;
    }

    @Override
    public void close() throws IORuntimeException {
        IoUtil.closeQuietly(this.resource);
    }

    private void readEntry(ZipEntry zipEntry, File outFile) {
        String path = zipEntry.getName();
        if (FileUtil.isWindows()) {
            path = StrUtil.replace((CharSequence)path, (CharSequence)"*", "_");
        }
        File outItemFile = FileUtil.file(outFile, path);
        if (zipEntry.isDirectory()) {
            outItemFile.mkdirs();
        } else {
            FileUtil.writeFromStream(this.resource.get(zipEntry), outItemFile, false);
        }
    }
}

