/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.compress;

import cn.ujava.common.compress.ZipReader;
import cn.ujava.common.compress.ZipWriter;
import cn.ujava.common.io.file.FileUtil;
import cn.ujava.common.io.resource.Resource;
import cn.ujava.common.text.StrUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ZipReplacer
implements Closeable {
    private final ZipReader zipReader;
    private final boolean ignoreCase;
    private final Map<String, Resource> replacedResources = new HashMap<String, Resource>();

    public ZipReplacer(ZipReader zipReader, boolean ignoreCase) {
        this.zipReader = zipReader;
        this.ignoreCase = ignoreCase;
    }

    public ZipReplacer addReplace(String entryPath, Resource resource) {
        this.replacedResources.put(entryPath, resource);
        return this;
    }

    public void write(ZipWriter writer) {
        this.zipReader.read(entry -> {
            for (String key : this.replacedResources.keySet()) {
                String entryName = entry.getName();
                if (ZipReplacer.isSamePath(entryName, key, this.ignoreCase)) {
                    writer.add(key, this.replacedResources.get(key).getStream());
                    continue;
                }
                writer.add(entryName, this.zipReader.get(entryName));
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.zipReader.close();
    }

    private static boolean isSamePath(String entryPath, String targetPath, boolean ignoreCase) {
        entryPath = StrUtil.removePrefix(FileUtil.normalize(entryPath), "/");
        targetPath = StrUtil.removePrefix(FileUtil.normalize(targetPath), "/");
        return StrUtil.equals(entryPath, targetPath, ignoreCase);
    }
}

