/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.convert;

import cn.ujava.common.bean.BeanUtil;
import cn.ujava.common.bean.RecordUtil;
import cn.ujava.common.convert.ConvertException;
import cn.ujava.common.convert.Converter;
import cn.ujava.common.convert.RegisterConverter;
import cn.ujava.common.convert.impl.ArrayConverter;
import cn.ujava.common.convert.impl.BeanConverter;
import cn.ujava.common.convert.impl.ClassConverter;
import cn.ujava.common.convert.impl.CollectionConverter;
import cn.ujava.common.convert.impl.DateConverter;
import cn.ujava.common.convert.impl.EntryConverter;
import cn.ujava.common.convert.impl.EnumConverter;
import cn.ujava.common.convert.impl.KBeanConverter;
import cn.ujava.common.convert.impl.MapConverter;
import cn.ujava.common.convert.impl.NumberConverter;
import cn.ujava.common.convert.impl.PrimitiveConverter;
import cn.ujava.common.convert.impl.RecordConverter;
import cn.ujava.common.lang.Opt;
import cn.ujava.common.reflect.TypeReference;
import cn.ujava.common.reflect.TypeUtil;
import cn.ujava.common.reflect.kotlin.KClassUtil;
import cn.ujava.common.util.ObjUtil;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Optional;

public class CompositeConverter
extends RegisterConverter {
    private static final long serialVersionUID = 1L;

    public static CompositeConverter getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public Object convert(Type type, Object value) throws ConvertException {
        return this.convert(type, value, null);
    }

    @Override
    public <T> T convert(Type type, Object value, T defaultValue) throws ConvertException {
        return this.convert(type, value, defaultValue, true);
    }

    public <T> T convert(Type type, Object value, T defaultValue, boolean isCustomFirst) throws ConvertException {
        Object result;
        Converter converter;
        if (ObjUtil.isNull(value)) {
            return defaultValue;
        }
        if (TypeUtil.isUnknown(type)) {
            if (null == defaultValue) {
                return (T)value;
            }
            type = defaultValue.getClass();
        }
        if (value instanceof Opt && ObjUtil.isNull(value = ((Opt)value).get())) {
            return defaultValue;
        }
        if (value instanceof Optional && ObjUtil.isNull(value = ((Optional)value).orElse(null))) {
            return defaultValue;
        }
        if (value instanceof Converter) {
            return ((Converter)value).convert(type, value, defaultValue);
        }
        if (type instanceof TypeReference) {
            type = ((TypeReference)type).getType();
        }
        if (null != (converter = this.getConverter(type, isCustomFirst))) {
            return converter.convert(type, value, defaultValue);
        }
        Class<?> rowType = TypeUtil.getClass(type);
        if (null == rowType) {
            if (null != defaultValue) {
                rowType = defaultValue.getClass();
            } else {
                throw new ConvertException("Can not get class from type: {}", type);
            }
        }
        if (null != (result = this.convertSpecial(type, rowType, value, defaultValue))) {
            return (T)result;
        }
        if (BeanUtil.isWritableBean(rowType)) {
            return (T)BeanConverter.INSTANCE.convert(type, value);
        }
        throw new ConvertException("Can not convert from {}: [{}] to [{}]", value.getClass().getName(), value, type.getTypeName());
    }

    private <T> T convertSpecial(Type type, Class<T> rowType, Object value, T defaultValue) {
        if (null == rowType) {
            return null;
        }
        if (Date.class.isAssignableFrom(rowType)) {
            return DateConverter.INSTANCE.convert(type, value, defaultValue);
        }
        if (Collection.class.isAssignableFrom(rowType)) {
            return (T)CollectionConverter.INSTANCE.convert(type, value, (Collection)defaultValue);
        }
        if (Map.class.isAssignableFrom(rowType)) {
            return (T)MapConverter.INSTANCE.convert(type, value, (Map)defaultValue);
        }
        if (Map.Entry.class.isAssignableFrom(rowType)) {
            return (T)EntryConverter.INSTANCE.convert(type, value);
        }
        if (rowType.isInstance(value)) {
            return (T)value;
        }
        if (rowType.isPrimitive()) {
            return PrimitiveConverter.INSTANCE.convert(type, value, defaultValue);
        }
        if (Number.class.isAssignableFrom(rowType)) {
            return NumberConverter.INSTANCE.convert(type, value, defaultValue);
        }
        if (rowType.isEnum()) {
            return EnumConverter.INSTANCE.convert(type, value, defaultValue);
        }
        if (rowType.isArray()) {
            return ArrayConverter.INSTANCE.convert(type, value, defaultValue);
        }
        if (RecordUtil.isRecord(rowType)) {
            return (T)RecordConverter.INSTANCE.convert(type, value);
        }
        if (KClassUtil.isKotlinClass(rowType)) {
            return (T)KBeanConverter.INSTANCE.convert(type, value);
        }
        if ("java.lang.Class".equals(rowType.getName())) {
            return (T)ClassConverter.INSTANCE.convert(type, value);
        }
        return null;
    }

    private static class SingletonHolder {
        private static final CompositeConverter INSTANCE = new CompositeConverter();

        private SingletonHolder() {
        }
    }
}

