/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.convert.impl;

import cn.ujava.common.convert.AbstractConverter;
import cn.ujava.common.convert.ConvertException;
import cn.ujava.common.date.DateException;
import cn.ujava.common.date.DateTime;
import cn.ujava.common.date.DateUtil;
import cn.ujava.common.text.StrUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class XMLGregorianCalendarConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    private String format;
    private final DatatypeFactory datatypeFactory;

    public XMLGregorianCalendarConverter() {
        try {
            this.datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new DateException(e);
        }
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected XMLGregorianCalendar convertInternal(Class<?> targetClass, Object value) {
        if (value instanceof GregorianCalendar) {
            return this.datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)value);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        if (value instanceof Date) {
            gregorianCalendar.setTime((Date)value);
        } else if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            gregorianCalendar.setTimeZone(calendar.getTimeZone());
            gregorianCalendar.setFirstDayOfWeek(calendar.getFirstDayOfWeek());
            gregorianCalendar.setLenient(calendar.isLenient());
            gregorianCalendar.setTimeInMillis(calendar.getTimeInMillis());
        } else if (value instanceof Long) {
            gregorianCalendar.setTimeInMillis((Long)value);
        } else {
            DateTime date;
            String valueStr = this.convertToStr(value);
            DateTime dateTime = date = StrUtil.isBlank(this.format) ? DateUtil.parse(valueStr) : DateUtil.parse((CharSequence)valueStr, this.format);
            if (null == date) {
                throw new ConvertException("Unsupported date value: " + value);
            }
            gregorianCalendar.setTime(date);
        }
        return this.datatypeFactory.newXMLGregorianCalendar(gregorianCalendar);
    }
}

