/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.data;

import cn.ujava.common.data.IdcardUtil;
import cn.ujava.common.date.DatePattern;
import cn.ujava.common.date.DateTime;
import cn.ujava.common.date.DateUtil;
import cn.ujava.common.lang.Assert;
import cn.ujava.common.lang.Validator;
import cn.ujava.common.regex.PatternPool;
import cn.ujava.common.regex.ReUtil;
import cn.ujava.common.text.CharUtil;
import cn.ujava.common.text.StrUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CIN {
    public static final int CHINA_ID_MIN_LENGTH = 15;
    public static final int CHINA_ID_MAX_LENGTH = 18;
    private static final int[] POWER = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static final Map<String, String> CITY_CODES = new HashMap<String, String>();
    private final String code;

    public static CIN of(String code) {
        return new CIN(code);
    }

    public CIN(String code) {
        int length = code.length();
        Assert.isTrue(length == 15 || length == 18, "CIN length must be 15 or 18!", new Object[0]);
        if (length == 15) {
            code = CIN.convert15To18(code);
        }
        Assert.isTrue(CIN.verify(code, true), "Invalid CIN code!", new Object[0]);
        this.code = code;
    }

    public String getProvinceCode() {
        return this.code.substring(0, 2);
    }

    public String getProvince() {
        String code = this.getProvinceCode();
        if (StrUtil.isNotBlank(code)) {
            return CITY_CODES.get(code);
        }
        return null;
    }

    public String getCityCode() {
        return this.code.substring(0, 4);
    }

    public String getDistrictCode() {
        return this.code.substring(0, 6);
    }

    public String getBirth() {
        return this.code.substring(6, 14);
    }

    public DateTime getBirthDate() {
        String birth = this.getBirth();
        return DateUtil.parse((CharSequence)birth, DatePattern.PURE_DATE_FORMAT);
    }

    public int getAge() {
        return this.getAge(DateUtil.now());
    }

    public int getAge(Date dateToCompare) {
        return DateUtil.age(this.getBirthDate(), dateToCompare);
    }

    public Short getBirthYear() {
        return Short.valueOf(this.code.substring(6, 10));
    }

    public Short getBirthMonth() {
        return Short.valueOf(this.code.substring(10, 12));
    }

    public Short getBirthDay() {
        return Short.valueOf(this.code.substring(12, 14));
    }

    public int getGender() {
        char sCardChar = this.code.charAt(16);
        return sCardChar % 2 != 0 ? 1 : 0;
    }

    public static String convert15To18(String idCard) {
        int sYear;
        if (idCard.length() != 15) {
            return null;
        }
        if (ReUtil.isMatch(PatternPool.NUMBERS, (CharSequence)idCard)) {
            DateTime birthDate;
            String birthday = idCard.substring(6, 12);
            try {
                birthDate = DateUtil.parse((CharSequence)birthday, "yyMMdd");
            }
            catch (Exception ignore) {
                throw new IllegalArgumentException("Invalid birthday: " + birthday);
            }
            sYear = DateUtil.year(birthDate);
            if (sYear > 2000) {
                sYear -= 100;
            }
        } else {
            return null;
        }
        StringBuilder idCard18 = StrUtil.builder().append(idCard, 0, 6).append(sYear).append(idCard.substring(8));
        char sVal = CIN.getVerifyCode18(idCard18.toString());
        idCard18.append(sVal);
        return idCard18.toString();
    }

    public static String convert18To15(String idCard) {
        if (StrUtil.isNotBlank(idCard) && IdcardUtil.isValidCard18(idCard)) {
            return idCard.substring(0, 6) + idCard.substring(8, idCard.length() - 1);
        }
        return idCard;
    }

    public static boolean verify(String idCard, boolean ignoreCase) {
        if (StrUtil.isBlank(idCard) || 18 != idCard.length()) {
            return false;
        }
        String proCode = idCard.substring(0, 2);
        if (null == CITY_CODES.get(proCode)) {
            return false;
        }
        if (!Validator.isBirthday(idCard.substring(6, 14))) {
            return false;
        }
        String code17 = idCard.substring(0, 17);
        if (ReUtil.isMatch(PatternPool.NUMBERS, (CharSequence)code17)) {
            char val = CIN.getVerifyCode18(code17);
            return CharUtil.equals(val, idCard.charAt(17), ignoreCase);
        }
        return false;
    }

    private static char getVerifyCode18(String code17) {
        int sum = CIN.getPowerSum(code17.toCharArray());
        return CIN.getVerifyCode18(sum);
    }

    private static char getVerifyCode18(int iSum) {
        switch (iSum % 11) {
            case 10: {
                return '2';
            }
            case 9: {
                return '3';
            }
            case 8: {
                return '4';
            }
            case 7: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 5: {
                return '7';
            }
            case 4: {
                return '8';
            }
            case 3: {
                return '9';
            }
            case 2: {
                return 'X';
            }
            case 1: {
                return '0';
            }
            case 0: {
                return '1';
            }
        }
        return ' ';
    }

    private static int getPowerSum(char[] iArr) {
        int iSum = 0;
        if (POWER.length == iArr.length) {
            for (int i = 0; i < iArr.length; ++i) {
                iSum += Integer.parseInt(String.valueOf(iArr[i])) * POWER[i];
            }
        }
        return iSum;
    }

    static {
        CITY_CODES.put("11", "\u5317\u4eac");
        CITY_CODES.put("12", "\u5929\u6d25");
        CITY_CODES.put("13", "\u6cb3\u5317");
        CITY_CODES.put("14", "\u5c71\u897f");
        CITY_CODES.put("15", "\u5185\u8499\u53e4");
        CITY_CODES.put("21", "\u8fbd\u5b81");
        CITY_CODES.put("22", "\u5409\u6797");
        CITY_CODES.put("23", "\u9ed1\u9f99\u6c5f");
        CITY_CODES.put("31", "\u4e0a\u6d77");
        CITY_CODES.put("32", "\u6c5f\u82cf");
        CITY_CODES.put("33", "\u6d59\u6c5f");
        CITY_CODES.put("34", "\u5b89\u5fbd");
        CITY_CODES.put("35", "\u798f\u5efa");
        CITY_CODES.put("36", "\u6c5f\u897f");
        CITY_CODES.put("37", "\u5c71\u4e1c");
        CITY_CODES.put("41", "\u6cb3\u5357");
        CITY_CODES.put("42", "\u6e56\u5317");
        CITY_CODES.put("43", "\u6e56\u5357");
        CITY_CODES.put("44", "\u5e7f\u4e1c");
        CITY_CODES.put("45", "\u5e7f\u897f");
        CITY_CODES.put("46", "\u6d77\u5357");
        CITY_CODES.put("50", "\u91cd\u5e86");
        CITY_CODES.put("51", "\u56db\u5ddd");
        CITY_CODES.put("52", "\u8d35\u5dde");
        CITY_CODES.put("53", "\u4e91\u5357");
        CITY_CODES.put("54", "\u897f\u85cf");
        CITY_CODES.put("61", "\u9655\u897f");
        CITY_CODES.put("62", "\u7518\u8083");
        CITY_CODES.put("63", "\u9752\u6d77");
        CITY_CODES.put("64", "\u5b81\u590f");
        CITY_CODES.put("65", "\u65b0\u7586");
        CITY_CODES.put("71", "\u53f0\u6e7e");
        CITY_CODES.put("81", "\u9999\u6e2f");
        CITY_CODES.put("82", "\u6fb3\u95e8");
        CITY_CODES.put("83", "\u53f0\u6e7e");
        CITY_CODES.put("91", "\u56fd\u5916");
    }
}

