/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.func;

import cn.ujava.common.bean.BeanUtil;
import cn.ujava.common.classloader.ClassLoaderUtil;
import cn.ujava.common.lang.Assert;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class LambdaInfo {
    private static final Type[] EMPTY_TYPE = new Type[0];
    private final Type[] instantiatedMethodParameterTypes;
    private final Type[] parameterTypes;
    private final Type returnType;
    private final String name;
    private final Executable executable;
    private final Class<?> clazz;
    private final SerializedLambda lambda;

    public LambdaInfo(Executable executable, SerializedLambda lambda) {
        Assert.notNull(executable, "executable must be not null!", new Object[0]);
        boolean isMethod = executable instanceof Method;
        boolean isConstructor = executable instanceof Constructor;
        Assert.isTrue(isMethod || isConstructor, "Unsupported executable type: " + executable.getClass(), new Object[0]);
        this.returnType = isMethod ? ((Method)executable).getGenericReturnType() : ((Constructor)executable).getDeclaringClass();
        this.parameterTypes = executable.getGenericParameterTypes();
        this.name = executable.getName();
        this.clazz = executable.getDeclaringClass();
        this.executable = executable;
        this.lambda = lambda;
        String instantiatedMethodType = lambda.getInstantiatedMethodType();
        int index = instantiatedMethodType.indexOf(";)");
        this.instantiatedMethodParameterTypes = index > -1 ? LambdaInfo.getInstantiatedMethodParamTypes(instantiatedMethodType.substring(1, index + 1)) : EMPTY_TYPE;
    }

    public Type[] getInstantiatedMethodParameterTypes() {
        return this.instantiatedMethodParameterTypes;
    }

    public Type[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public String getName() {
        return this.name;
    }

    public String getFieldName() {
        return BeanUtil.getFieldName(this.getName());
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public SerializedLambda getLambda() {
        return this.lambda;
    }

    private static Type[] getInstantiatedMethodParamTypes(String className) {
        String[] instantiatedTypeNames = className.split(";");
        Type[] types = new Type[instantiatedTypeNames.length];
        for (int i = 0; i < instantiatedTypeNames.length; ++i) {
            boolean isArray = instantiatedTypeNames[i].startsWith("[");
            if (isArray && !instantiatedTypeNames[i].endsWith(";")) {
                int n = i;
                instantiatedTypeNames[n] = instantiatedTypeNames[n] + ";";
            } else {
                if (instantiatedTypeNames[i].startsWith("L")) {
                    instantiatedTypeNames[i] = instantiatedTypeNames[i].substring(1);
                }
                if (instantiatedTypeNames[i].endsWith(";")) {
                    instantiatedTypeNames[i] = instantiatedTypeNames[i].substring(0, instantiatedTypeNames[i].length() - 1);
                }
            }
            types[i] = ClassLoaderUtil.loadClass(instantiatedTypeNames[i]);
        }
        return types;
    }
}

