/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.io.file;

import cn.ujava.common.func.SerConsumer;
import cn.ujava.common.io.IORuntimeException;
import cn.ujava.common.io.file.FileUtil;
import cn.ujava.common.io.watch.SimpleWatcher;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.WatchEvent;

public class LineReadWatcher
extends SimpleWatcher
implements Runnable {
    private final RandomAccessFile randomAccessFile;
    private final Charset charset;
    private final SerConsumer<String> lineHandler;

    public LineReadWatcher(RandomAccessFile randomAccessFile, Charset charset, SerConsumer<String> lineHandler) {
        this.randomAccessFile = randomAccessFile;
        this.charset = charset;
        this.lineHandler = lineHandler;
    }

    @Override
    public void run() {
        this.onModify(null, null);
    }

    @Override
    public void onModify(WatchEvent<?> event, Path currentPath) {
        RandomAccessFile randomAccessFile = this.randomAccessFile;
        Charset charset = this.charset;
        SerConsumer<String> lineHandler = this.lineHandler;
        try {
            long currentLength = randomAccessFile.length();
            long position = randomAccessFile.getFilePointer();
            if (position == currentLength) {
                return;
            }
            if (currentLength < position) {
                randomAccessFile.seek(currentLength);
                return;
            }
            FileUtil.readLines(randomAccessFile, charset, lineHandler);
            randomAccessFile.seek(currentLength);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

