/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.io.file;

import cn.ujava.common.io.IORuntimeException;
import cn.ujava.common.io.IoUtil;
import cn.ujava.common.io.file.PathCopier;
import cn.ujava.common.io.file.PathDeleter;
import cn.ujava.common.io.file.PathMover;
import cn.ujava.common.util.CharsetUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class PathUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDirEmpty(Path dirPath) {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(dirPath);){
            boolean bl = !dirStream.iterator().hasNext();
            return bl;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static List<File> loopFiles(Path path, FileFilter fileFilter) {
        return PathUtil.loopFiles(path, -1, fileFilter);
    }

    public static List<File> loopFiles(Path path, int maxDepth, final FileFilter fileFilter) {
        final ArrayList<File> fileList = new ArrayList<File>();
        if (null == path || !Files.exists(path, new LinkOption[0])) {
            return fileList;
        }
        if (!PathUtil.isDirectory(path)) {
            File file = path.toFile();
            if (null == fileFilter || fileFilter.accept(file)) {
                fileList.add(file);
            }
            return fileList;
        }
        PathUtil.walkFiles(path, maxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                File file = path.toFile();
                if (null == fileFilter || fileFilter.accept(file)) {
                    fileList.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return fileList;
    }

    public static void walkFiles(Path start, FileVisitor<? super Path> visitor) {
        PathUtil.walkFiles(start, -1, visitor);
    }

    public static void walkFiles(Path start, int maxDepth, FileVisitor<? super Path> visitor) {
        if (maxDepth < 0) {
            maxDepth = Integer.MAX_VALUE;
        }
        try {
            Files.walkFileTree(start, EnumSet.noneOf(FileVisitOption.class), maxDepth, visitor);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void del(Path path) throws IORuntimeException {
        PathDeleter.of(path).del();
    }

    public static void clean(Path path) {
        PathDeleter.of(path).clean();
    }

    public static Path copy(Path src, Path target, CopyOption ... options) throws IORuntimeException {
        return PathCopier.of(src, target, options).copy();
    }

    public static Path copyContent(Path src, Path target, CopyOption ... options) throws IORuntimeException {
        return PathCopier.of(src, target, options).copyContent();
    }

    public static boolean isDirectory(Path path) {
        return PathUtil.isDirectory(path, false);
    }

    public static boolean isExistsAndNotDirectory(Path path, boolean isFollowLinks) {
        return PathUtil.exists(path, isFollowLinks) && !PathUtil.isDirectory(path, isFollowLinks);
    }

    public static boolean isDirectory(Path path, boolean isFollowLinks) {
        LinkOption[] linkOptionArray;
        if (null == path) {
            return false;
        }
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] options = linkOptionArray;
        return Files.isDirectory(path, options);
    }

    public static Path getPathEle(Path path, int index) {
        return PathUtil.subPath(path, index, index == -1 ? path.getNameCount() : index + 1);
    }

    public static Path getLastPathEle(Path path) {
        return PathUtil.getPathEle(path, path.getNameCount() - 1);
    }

    public static Path subPath(Path path, int fromIndex, int toIndex) {
        if (null == path) {
            return null;
        }
        int len = path.getNameCount();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex > len) {
            fromIndex = len;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return null;
        }
        return path.subpath(fromIndex, toIndex);
    }

    public static BasicFileAttributes getAttributes(Path path, boolean isFollowLinks) throws IORuntimeException {
        LinkOption[] linkOptionArray;
        if (null == path) {
            return null;
        }
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] options = linkOptionArray;
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, options);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedInputStream getInputStream(Path path) throws IORuntimeException {
        InputStream in;
        try {
            in = Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return IoUtil.toBuffered(in);
    }

    public static BufferedReader getUtf8Reader(Path path) throws IORuntimeException {
        return PathUtil.getReader(path, CharsetUtil.UTF_8);
    }

    public static BufferedReader getReader(Path path, Charset charset) throws IORuntimeException {
        return IoUtil.toReader(PathUtil.getInputStream(path), charset);
    }

    public static byte[] readBytes(Path path) {
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedOutputStream getOutputStream(Path path) throws IORuntimeException {
        OutputStream in;
        try {
            in = Files.newOutputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return IoUtil.toBuffered(in);
    }

    public static Path rename(Path path, String newName, boolean isOverride) {
        return PathUtil.move(path, path.resolveSibling(newName), isOverride);
    }

    public static Path move(Path src, Path target, boolean isOverride) {
        return PathMover.of(src, target, isOverride).move();
    }

    public static Path moveContent(Path src, Path target, boolean isOverride) {
        return PathMover.of(src, target, isOverride).moveContent();
    }

    public static boolean equals(Path file1, Path file2) throws IORuntimeException {
        try {
            return Files.isSameFile(file1, file2);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static boolean isFile(Path path, boolean isFollowLinks) {
        LinkOption[] linkOptionArray;
        if (null == path) {
            return false;
        }
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] options = linkOptionArray;
        return Files.isRegularFile(path, options);
    }

    public static boolean isSymlink(Path path) {
        return Files.isSymbolicLink(path);
    }

    public static boolean isOther(Path path) {
        return PathUtil.getAttributes(path, false).isOther();
    }

    public static boolean exists(Path path, boolean isFollowLinks) {
        LinkOption[] linkOptionArray;
        if (null == path) {
            return false;
        }
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] options = linkOptionArray;
        return Files.exists(path, options);
    }

    public static boolean isSub(Path parent, Path sub) {
        return PathUtil.toAbsNormal(sub).startsWith(PathUtil.toAbsNormal(parent));
    }

    public static Path toAbsNormal(Path path) {
        if (null == path) {
            return null;
        }
        return path.toAbsolutePath().normalize();
    }

    public static Path toRealPath(Path path) throws IORuntimeException {
        if (null != path) {
            try {
                path = path.toRealPath(new LinkOption[0]);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
        return path;
    }

    public static String getMimeType(Path file) {
        try {
            return Files.probeContentType(file);
        }
        catch (IOException ignore) {
            return null;
        }
    }

    public static Path mkdir(Path dir) {
        if (null != dir && !PathUtil.exists(dir, false)) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
        return dir;
    }

    public static Path mkParentDirs(Path path) {
        return PathUtil.mkdir(path.getParent());
    }

    public static String getName(Path path) {
        if (null == path) {
            return null;
        }
        return path.getFileName().toString();
    }

    public static Path createTempFile(String prefix, String suffix, Path dir) throws IORuntimeException {
        int exceptionsCount = 0;
        while (true) {
            try {
                if (null == dir) {
                    return Files.createTempFile(prefix, suffix, new FileAttribute[0]);
                }
                return Files.createTempFile(PathUtil.mkdir(dir), prefix, suffix, new FileAttribute[0]);
            }
            catch (IOException ioex) {
                if (++exceptionsCount < 50) continue;
                throw new IORuntimeException(ioex);
            }
            break;
        }
    }
}

