/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.io.stream;

import cn.ujava.common.io.ByteOrderMark;
import cn.ujava.common.io.IORuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class BOMInputStream
extends InputStream {
    private final PushbackInputStream in;
    private boolean isInited = false;
    private final String defaultCharset;
    private String charset;
    private static final int BOM_SIZE = 4;

    public BOMInputStream(InputStream in) {
        this(in, "UTF-8");
    }

    public BOMInputStream(InputStream in, String defaultCharset) {
        this.in = new PushbackInputStream(in, 4);
        this.defaultCharset = defaultCharset;
    }

    public String getDefaultCharset() {
        return this.defaultCharset;
    }

    public String getCharset() {
        if (!this.isInited) {
            try {
                this.init();
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
        }
        return this.charset;
    }

    @Override
    public void close() throws IOException {
        this.isInited = true;
        this.in.close();
    }

    @Override
    public int read() throws IOException {
        this.isInited = true;
        return this.in.read();
    }

    protected void init() throws IOException {
        if (this.isInited) {
            return;
        }
        byte[] bom = new byte[4];
        int unread = 0;
        int n = this.in.read(bom, 0, bom.length);
        for (ByteOrderMark byteOrderMark : ByteOrderMark.ALL) {
            if (!byteOrderMark.test(bom)) continue;
            this.charset = byteOrderMark.getCharsetName();
            unread = n - byteOrderMark.length();
            break;
        }
        if (0 == unread) {
            this.charset = this.defaultCharset;
            unread = n;
        }
        if (unread > 0) {
            this.in.unread(bom, n - unread, unread);
        }
        this.isInited = true;
    }
}

