/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.lang.tuple;

import cn.ujava.common.exception.CloneException;
import java.io.Serializable;
import java.util.Objects;

public class Pair<L, R>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected L left;
    protected R right;

    public static <L, R> Pair<L, R> of(L left, R right) {
        return new Pair<L, R>(left, right);
    }

    public Pair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public L getLeft() {
        return this.left;
    }

    public R getRight() {
        return this.right;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        return Objects.equals(this.left, pair.left) && Objects.equals(this.right, pair.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }

    public String toString() {
        return "Pair{left=" + this.left + ", right=" + this.right + '}';
    }

    public Pair<L, R> clone() {
        try {
            return (Pair)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CloneException(e);
        }
    }
}

