/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.math;

import cn.ujava.common.array.ArrayUtil;
import cn.ujava.common.comparator.CompareUtil;
import cn.ujava.common.lang.Assert;
import cn.ujava.common.math.Calculator;
import cn.ujava.common.math.NumberParser;
import cn.ujava.common.math.NumberValidator;
import cn.ujava.common.text.StrUtil;
import cn.ujava.common.util.ObjUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;

public class NumberUtil
extends NumberValidator {
    private static final int DEFAULT_DIV_SCALE = 10;

    public static BigDecimal add(Number ... values) {
        if (ArrayUtil.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        Number value = values[0];
        BigDecimal result = NumberUtil.toBigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.add(NumberUtil.toBigDecimal(value));
        }
        return result;
    }

    public static BigDecimal add(String ... values) {
        if (ArrayUtil.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        String value = values[0];
        BigDecimal result = NumberUtil.toBigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (!StrUtil.isNotBlank(value)) continue;
            result = result.add(NumberUtil.toBigDecimal(value));
        }
        return result;
    }

    public static BigDecimal sub(Number ... values) {
        if (ArrayUtil.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        Number value = values[0];
        BigDecimal result = NumberUtil.toBigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.subtract(NumberUtil.toBigDecimal(value));
        }
        return result;
    }

    public static BigDecimal sub(String ... values) {
        if (ArrayUtil.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        String value = values[0];
        BigDecimal result = NumberUtil.toBigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (!StrUtil.isNotBlank(value)) continue;
            result = result.subtract(NumberUtil.toBigDecimal(value));
        }
        return result;
    }

    public static BigDecimal mul(Number ... values) {
        if (ArrayUtil.isEmpty(values) || ArrayUtil.hasNull(values)) {
            return BigDecimal.ZERO;
        }
        Number value = values[0];
        if (NumberUtil.isZero(value)) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = NumberUtil.toBigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (NumberUtil.isZero(value)) {
                return BigDecimal.ZERO;
            }
            result = result.multiply(NumberUtil.toBigDecimal(value));
        }
        return result;
    }

    public static BigDecimal mul(String ... values) {
        if (ArrayUtil.isEmpty(values) || ArrayUtil.hasNull(values)) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = NumberUtil.toBigDecimal(values[0]);
        if (NumberUtil.isZero(result)) {
            return BigDecimal.ZERO;
        }
        for (int i = 1; i < values.length; ++i) {
            BigDecimal ele = NumberUtil.toBigDecimal(values[i]);
            if (NumberUtil.isZero(ele)) {
                return BigDecimal.ZERO;
            }
            result = result.multiply(ele);
        }
        return result;
    }

    public static BigDecimal div(Number v1, Number v2) {
        return NumberUtil.div(v1, v2, 10);
    }

    public static BigDecimal div(String v1, String v2) {
        return NumberUtil.div(v1, v2, 10);
    }

    public static BigDecimal div(Number v1, Number v2, int scale) {
        return NumberUtil.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal div(String v1, String v2, int scale) {
        return NumberUtil.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal div(String v1, String v2, int scale, RoundingMode roundingMode) {
        return NumberUtil.div(NumberUtil.toBigDecimal(v1), NumberUtil.toBigDecimal(v2), scale, roundingMode);
    }

    public static BigDecimal div(Number v1, Number v2, int scale, RoundingMode roundingMode) {
        Assert.notNull(v2, "Divisor must be not null !", new Object[0]);
        if (null == v1 || NumberUtil.isZero(v1)) {
            return BigDecimal.ZERO;
        }
        if (scale < 0) {
            scale = -scale;
        }
        return NumberUtil.toBigDecimal(v1).divide(NumberUtil.toBigDecimal(v2), scale, roundingMode);
    }

    public static int ceilDiv(int v1, int v2) {
        return (int)Math.ceil((double)v1 / (double)v2);
    }

    public static BigDecimal round(double v, int scale) {
        return NumberUtil.round(v, scale, RoundingMode.HALF_UP);
    }

    public static String roundStr(double v, int scale) {
        return NumberUtil.round(v, scale).toPlainString();
    }

    public static BigDecimal round(String numberStr, int scale) {
        return NumberUtil.round(numberStr, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal round(BigDecimal number, int scale) {
        return NumberUtil.round(number, scale, RoundingMode.HALF_UP);
    }

    public static String roundStr(String numberStr, int scale) {
        return NumberUtil.round(numberStr, scale).toPlainString();
    }

    public static BigDecimal round(double v, int scale, RoundingMode roundingMode) {
        return NumberUtil.round(Double.toString(v), scale, roundingMode);
    }

    public static String roundStr(double v, int scale, RoundingMode roundingMode) {
        return NumberUtil.round(v, scale, roundingMode).toPlainString();
    }

    public static BigDecimal round(String numberStr, int scale, RoundingMode roundingMode) {
        Assert.notBlank(numberStr);
        if (scale < 0) {
            scale = 0;
        }
        return NumberUtil.round(NumberUtil.toBigDecimal(numberStr), scale, roundingMode);
    }

    public static BigDecimal round(BigDecimal number, int scale, RoundingMode roundingMode) {
        if (null == number) {
            number = BigDecimal.ZERO;
        }
        if (scale < 0) {
            scale = 0;
        }
        if (null == roundingMode) {
            roundingMode = RoundingMode.HALF_UP;
        }
        return number.setScale(scale, roundingMode);
    }

    public static String roundStr(String numberStr, int scale, RoundingMode roundingMode) {
        return NumberUtil.round(numberStr, scale, roundingMode).toPlainString();
    }

    public static BigDecimal roundHalfEven(Number number, int scale) {
        return NumberUtil.round(NumberUtil.toBigDecimal(number), scale, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal roundDown(Number number, int scale) {
        return NumberUtil.round(NumberUtil.toBigDecimal(number), scale, RoundingMode.DOWN);
    }

    public static String format(String pattern, double value) {
        Assert.isTrue(NumberUtil.isValid(value), "value is NaN or Infinite!", new Object[0]);
        return new DecimalFormat(pattern).format(value);
    }

    public static String format(String pattern, long value) {
        return new DecimalFormat(pattern).format(value);
    }

    public static String format(String pattern, Object value) {
        return NumberUtil.format(pattern, value, null);
    }

    public static String format(String pattern, Object value, RoundingMode roundingMode) {
        if (value instanceof Number) {
            Assert.isTrue(NumberUtil.isValidNumber((Number)value), "value is NaN or Infinite!", new Object[0]);
        }
        DecimalFormat decimalFormat = new DecimalFormat(pattern);
        if (null != roundingMode) {
            decimalFormat.setRoundingMode(roundingMode);
        }
        return decimalFormat.format(value);
    }

    public static String formatMoney(double value) {
        return NumberUtil.format(",##0.00", value);
    }

    public static String formatPercent(double number, int scale) {
        NumberFormat format = NumberFormat.getPercentInstance();
        format.setMaximumFractionDigits(scale);
        return format.format(number);
    }

    public static String formatThousands(double number, int scale) {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(scale);
        return format.format(number);
    }

    public static int[] range(int stopIncluded) {
        return NumberUtil.range(0, stopIncluded, 1);
    }

    public static int[] range(int startInclude, int stopIncluded) {
        return NumberUtil.range(startInclude, stopIncluded, 1);
    }

    public static int[] range(int startInclude, int stopIncluded, int step) {
        if (startInclude > stopIncluded) {
            int tmp = startInclude;
            startInclude = stopIncluded;
            stopIncluded = tmp;
        }
        if (step <= 0) {
            step = 1;
        }
        int deviation = stopIncluded + 1 - startInclude;
        int length = deviation / step;
        if (deviation % step != 0) {
            ++length;
        }
        int[] range = new int[length];
        for (int i = 0; i < length; ++i) {
            range[i] = startInclude;
            startInclude += step;
        }
        return range;
    }

    public static Collection<Integer> appendRange(int start, int stop, Collection<Integer> values) {
        return NumberUtil.appendRange(start, stop, 1, values);
    }

    public static Collection<Integer> appendRange(int startInclude, int stopInclude, int step, Collection<Integer> values) {
        if (startInclude < stopInclude) {
            step = Math.abs(step);
        } else if (startInclude > stopInclude) {
            step = -Math.abs(step);
        } else {
            values.add(startInclude);
            return values;
        }
        int i = startInclude;
        while (step > 0 ? i <= stopInclude : i >= stopInclude) {
            values.add(i);
            i += step;
        }
        return values;
    }

    public static String getBinaryStr(Number number) {
        if (number instanceof Long) {
            return Long.toBinaryString((Long)number);
        }
        if (number instanceof Integer) {
            return Integer.toBinaryString((Integer)number);
        }
        return Long.toBinaryString(number.longValue());
    }

    public static int binaryToInt(String binaryStr) {
        return Integer.parseInt(binaryStr, 2);
    }

    public static long binaryToLong(String binaryStr) {
        return Long.parseLong(binaryStr, 2);
    }

    public static boolean equals(Number number1, Number number2) {
        if (number1 instanceof BigDecimal && number2 instanceof BigDecimal) {
            return CompareUtil.equals((BigDecimal)number1, (BigDecimal)number2);
        }
        return Objects.equals(number1, number2);
    }

    public static String toStr(Number number, String defaultValue) {
        return null == number ? defaultValue : NumberUtil.toStr(number);
    }

    public static String toStr(Number number) {
        return NumberUtil.toStr(number, true);
    }

    public static String toStr(Number number, boolean isStripTrailingZeros) {
        Assert.notNull(number, "Number is null !", new Object[0]);
        if (number instanceof BigDecimal) {
            return NumberUtil.toStr((BigDecimal)number, isStripTrailingZeros);
        }
        Assert.isTrue(NumberUtil.isValidNumber(number), "Number is non-finite!", new Object[0]);
        String string = number.toString();
        if (isStripTrailingZeros && string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public static String toStr(BigDecimal bigDecimal) {
        return NumberUtil.toStr(bigDecimal, true);
    }

    public static String toStr(BigDecimal bigDecimal, boolean isStripTrailingZeros) {
        Assert.notNull(bigDecimal, "BigDecimal is null !", new Object[0]);
        if (isStripTrailingZeros) {
            bigDecimal = bigDecimal.stripTrailingZeros();
        }
        return bigDecimal.toPlainString();
    }

    public static BigDecimal toBigDecimal(Number number) {
        if (null == number) {
            return BigDecimal.ZERO;
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Long) {
            return new BigDecimal((Long)number);
        }
        if (number instanceof Integer) {
            return new BigDecimal((Integer)number);
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        return NumberUtil.toBigDecimal(number.toString());
    }

    public static BigDecimal toBigDecimal(String numberStr) {
        if (StrUtil.isBlank(numberStr)) {
            return BigDecimal.ZERO;
        }
        try {
            return new BigDecimal(numberStr);
        }
        catch (Exception exception) {
            return NumberUtil.toBigDecimal(NumberUtil.parseNumber(numberStr));
        }
    }

    public static BigInteger toBigInteger(Number number) {
        if (null == number) {
            return BigInteger.ZERO;
        }
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        if (number instanceof Long) {
            return BigInteger.valueOf((Long)number);
        }
        return NumberUtil.toBigInteger(number.longValue());
    }

    public static BigInteger toBigInteger(String number) {
        return StrUtil.isBlank(number) ? BigInteger.ZERO : new BigInteger(number);
    }

    public static int count(int total, int pageSize) {
        return (total + pageSize - 1) / pageSize;
    }

    public static int zeroToOne(int value) {
        return 0 == value ? 1 : value;
    }

    public static int nullToZero(Integer number) {
        return number == null ? 0 : number;
    }

    public static long nullToZero(Long number) {
        return number == null ? 0L : number;
    }

    public static double nullToZero(Double number) {
        return number == null ? 0.0 : number;
    }

    public static float nullToZero(Float number) {
        return number == null ? 0.0f : number.floatValue();
    }

    public static short nullToZero(Short number) {
        return number == null ? (short)0 : number;
    }

    public static byte nullToZero(Byte number) {
        return number == null ? (byte)0 : number;
    }

    public static BigInteger nullToZero(BigInteger number) {
        return number == null ? BigInteger.ZERO : number;
    }

    public static BigDecimal nullToZero(BigDecimal decimal) {
        return ObjUtil.defaultIfNull(decimal, BigDecimal.ZERO);
    }

    public static BigInteger parseBigInteger(String numberStr) {
        return NumberParser.INSTANCE.parseBigInteger(numberStr);
    }

    public static boolean isBeside(long number1, long number2) {
        return Math.abs(number1 - number2) == 1L;
    }

    public static boolean isBeside(int number1, int number2) {
        return Math.abs(number1 - number2) == 1;
    }

    public static int partValue(int total, int partCount) {
        return NumberUtil.partValue(total, partCount, true);
    }

    public static int partValue(int total, int partCount, boolean isPlusOneWhenHasRem) {
        int partValue = total / partCount;
        if (isPlusOneWhenHasRem && total % partCount > 0) {
            ++partValue;
        }
        return partValue;
    }

    public static BigDecimal pow(Number number, int n) {
        return NumberUtil.pow(NumberUtil.toBigDecimal(number), n);
    }

    public static BigDecimal pow(BigDecimal number, int n) {
        return number.pow(n);
    }

    public static boolean isPowerOfTwo(long n) {
        return n > 0L && (n & n - 1L) == 0L;
    }

    public static Integer parseInt(String numberStr, Integer defaultValue) {
        if (StrUtil.isNotBlank(numberStr)) {
            try {
                return NumberUtil.parseInt(numberStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int parseInt(String numberStr) throws NumberFormatException {
        return NumberParser.INSTANCE.parseInt(numberStr);
    }

    public static Long parseLong(String numberStr, Long defaultValue) {
        if (StrUtil.isNotBlank(numberStr)) {
            try {
                return NumberUtil.parseLong(numberStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static long parseLong(String numberStr) {
        return NumberParser.INSTANCE.parseLong(numberStr);
    }

    public static Float parseFloat(String numberStr, Float defaultValue) {
        if (StrUtil.isNotBlank(numberStr)) {
            try {
                return Float.valueOf(NumberUtil.parseFloat(numberStr));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static float parseFloat(String numberStr) {
        return NumberParser.INSTANCE.parseFloat(numberStr);
    }

    public static Double parseDouble(String numberStr, Double defaultValue) {
        if (StrUtil.isNotBlank(numberStr)) {
            try {
                return NumberUtil.parseDouble(numberStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static double parseDouble(String numberStr) {
        return NumberParser.INSTANCE.parseDouble(numberStr);
    }

    public static Number parseNumber(String numberStr, Number defaultValue) {
        if (StrUtil.isNotBlank(numberStr)) {
            try {
                return NumberUtil.parseNumber(numberStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Number parseNumber(String numberStr) throws NumberFormatException {
        return NumberParser.INSTANCE.parseNumber(numberStr);
    }

    public static Number parseNumber(String numberStr, Locale locale) throws NumberFormatException {
        return NumberParser.of(locale).parseNumber(numberStr);
    }

    public static boolean isValidNumber(Number number) {
        if (null == number) {
            return false;
        }
        if (number instanceof Double) {
            return !((Double)number).isInfinite() && !((Double)number).isNaN();
        }
        if (number instanceof Float) {
            return !((Float)number).isInfinite() && !((Float)number).isNaN();
        }
        return true;
    }

    public static boolean isValid(double number) {
        return !Double.isNaN(number) && !Double.isInfinite(number);
    }

    public static boolean isValid(float number) {
        return !Float.isNaN(number) && !Float.isInfinite(number);
    }

    public static double calculate(String expression) {
        return Calculator.conversion(expression);
    }

    public static double toDouble(Number value) {
        if (value instanceof Float) {
            return Double.parseDouble(value.toString());
        }
        return value.doubleValue();
    }

    public static boolean isOdd(int num) {
        return (num & 1) == 1;
    }

    public static boolean isEven(int num) {
        return !NumberUtil.isOdd(num);
    }

    public static boolean isZero(Number n) {
        Assert.notNull(n);
        if (n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof Long) {
            return 0L == n.longValue();
        }
        if (n instanceof BigInteger) {
            return NumberUtil.equals(BigInteger.ZERO, n);
        }
        if (n instanceof Float) {
            return 0.0f == n.floatValue();
        }
        if (n instanceof Double) {
            return 0.0 == n.doubleValue();
        }
        return NumberUtil.equals(NumberUtil.toBigDecimal(n), BigDecimal.ZERO);
    }
}

