/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.reflect.kotlin;

import cn.ujava.common.classloader.ClassLoaderUtil;
import cn.ujava.common.reflect.method.MethodUtil;
import java.lang.reflect.Method;
import java.util.Objects;

public class KParameter {
    private static final Method METHOD_GET_NAME;
    private static final Method METHOD_GET_TYPE;
    private static final Method METHOD_GET_JAVA_TYPE;
    private final String name;
    private final Class<?> type;

    public KParameter(Object kParameterInstance) {
        this.name = (String)MethodUtil.invoke(kParameterInstance, METHOD_GET_NAME, new Object[0]);
        Object kType = MethodUtil.invoke(kParameterInstance, METHOD_GET_TYPE, new Object[0]);
        this.type = (Class)MethodUtil.invoke(kType, METHOD_GET_JAVA_TYPE, new Object[0]);
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KParameter that = (KParameter)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public String toString() {
        return "KParameter{name='" + this.name + '\'' + ", type=" + this.type + '}';
    }

    static {
        Class kParameterClass = ClassLoaderUtil.loadClass("kotlin.reflect.KParameter");
        METHOD_GET_NAME = MethodUtil.getMethod(kParameterClass, "getName", new Class[0]);
        METHOD_GET_TYPE = MethodUtil.getMethod(kParameterClass, "getType", new Class[0]);
        Class kTypeClass = ClassLoaderUtil.loadClass("kotlin.reflect.jvm.internal.KTypeImpl");
        METHOD_GET_JAVA_TYPE = MethodUtil.getMethod(kTypeClass, "getJavaType", new Class[0]);
    }
}

