/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.reflect.method;

import cn.ujava.common.exception.ExceptionUtil;
import cn.ujava.common.exception.HutoolException;
import cn.ujava.common.lang.Assert;
import cn.ujava.common.reflect.lookup.LookupUtil;
import cn.ujava.common.reflect.method.MethodUtil;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;

public class MethodHandleUtil {
    public static <T> T invokeHandle(MethodHandle methodHandle, Object ... args) {
        try {
            return (T)methodHandle.invokeWithArguments(args);
        }
        catch (Throwable e) {
            throw ExceptionUtil.wrapRuntime(e);
        }
    }

    public static <T> T invoke(Object obj, Method method, Object ... args) throws HutoolException {
        Assert.notNull(method, "Method must be not null!", new Object[0]);
        return MethodHandleUtil.invokeExact(obj, method, MethodUtil.actualArgs(method, args));
    }

    public static <T> T invokeExact(Object obj, Method method, Object ... args) throws HutoolException {
        Assert.notNull(method, "Method must be not null!", new Object[0]);
        try {
            MethodHandle handle = LookupUtil.unreflectMethod(method);
            if (null != obj) {
                handle = handle.bindTo(obj);
            }
            return (T)handle.invokeWithArguments(args);
        }
        catch (Throwable e) {
            throw ExceptionUtil.wrapRuntime(e);
        }
    }
}

