/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.text.finder;

import cn.ujava.common.lang.Assert;
import cn.ujava.common.text.CharUtil;
import cn.ujava.common.text.finder.TextFinder;

public class CharFinder
extends TextFinder {
    private static final long serialVersionUID = 1L;
    private final char c;
    private final boolean caseInsensitive;

    public CharFinder(char c) {
        this(c, false);
    }

    public CharFinder(char c, boolean caseInsensitive) {
        this.c = c;
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    public int start(int from) {
        Assert.notNull(this.text, "Text to find must be not null!", new Object[0]);
        int limit = this.getValidEndIndex();
        if (this.negative) {
            for (int i = from; i > limit; --i) {
                if (!CharUtil.equals(this.c, this.text.charAt(i), this.caseInsensitive)) continue;
                return i;
            }
        } else {
            for (int i = from; i < limit; ++i) {
                if (!CharUtil.equals(this.c, this.text.charAt(i), this.caseInsensitive)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int end(int start) {
        if (start < 0) {
            return -1;
        }
        return start + 1;
    }
}

