/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.text.finder;

import cn.ujava.common.lang.Assert;
import cn.ujava.common.text.finder.TextFinder;
import java.util.function.Predicate;

public class CharMatcherFinder
extends TextFinder {
    private static final long serialVersionUID = 1L;
    private final Predicate<Character> matcher;

    public CharMatcherFinder(Predicate<Character> matcher) {
        this.matcher = matcher;
    }

    @Override
    public int start(int from) {
        Assert.notNull(this.text, "Text to find must be not null!", new Object[0]);
        int limit = this.getValidEndIndex();
        if (this.negative) {
            for (int i = from; i > limit; --i) {
                if (null != this.matcher && !this.matcher.test(Character.valueOf(this.text.charAt(i)))) continue;
                return i;
            }
        } else {
            for (int i = from; i < limit; ++i) {
                if (null != this.matcher && !this.matcher.test(Character.valueOf(this.text.charAt(i)))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int end(int start) {
        if (start < 0) {
            return -1;
        }
        return start + 1;
    }
}

