/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.text.finder;

import cn.ujava.common.regex.PatternPool;
import cn.ujava.common.text.finder.TextFinder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternFinder
extends TextFinder {
    private static final long serialVersionUID = 1L;
    private final Pattern pattern;
    private Matcher matcher;

    public PatternFinder(String regex, boolean caseInsensitive) {
        this(PatternPool.get(regex, caseInsensitive ? 2 : 0));
    }

    public PatternFinder(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public TextFinder setText(CharSequence text) {
        this.matcher = this.pattern.matcher(text);
        return super.setText(text);
    }

    @Override
    public TextFinder setNegative(boolean negative) {
        throw new UnsupportedOperationException("Negative is invalid for Pattern!");
    }

    @Override
    public int start(int from) {
        if (this.matcher.find(from) && this.matcher.end() <= this.getValidEndIndex()) {
            return this.matcher.start();
        }
        return -1;
    }

    @Override
    public int end(int start) {
        int end = this.matcher.end();
        int limit = this.endIndex < 0 ? this.text.length() : Math.min(this.endIndex, this.text.length());
        return end <= limit ? end : -1;
    }

    @Override
    public PatternFinder reset() {
        this.matcher.reset();
        return this;
    }
}

