/**
 * 享元模式
 * 示例：我们有一个 Shape 接口，它定义了一个 draw() 方法，用于绘制图形。
 * <p>
 * 然后，我们创建了一个具体的享元类 Circle ，它实现了 Shape 接口，并存储了圆的颜色、位置和半径等信息。
 * 接下来，我们创建了一个享元工厂类 ShapeFactory ，它维护了一个 Map ，用于存储已经创建的圆对象。在客户端需要绘制圆时，我们可以通过 ShapeFactory 获取已经存在的圆对象，如果不存在，则创建一个新的圆对象，并将其存储在 Map 中。
 * <p>
 * 最后，在客户端代码中，我们随机生成20个圆，每个圆的颜色、位置和半径都是随机的。通过 ShapeFactory 获取圆对象，并调用它的 draw() 方法来绘制图形。由于相同颜色的圆对象被共享，因此减少了内存使用和对象创建的开销。
 */
package cn.ujava.design.flyweight;
