/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.java.mapper;

import cn.vonce.sql.bean.ColumnInfo;
import cn.vonce.sql.bean.TableInfo;
import cn.vonce.sql.java.dao.MybatisSqlBeanDao;
import cn.vonce.sql.mapper.ResultSetDelegate;
import cn.vonce.sql.mapper.SqlBeanMapper;
import cn.vonce.sql.uitls.ReflectUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.resultset.DefaultResultSetHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(method="handleResultSets", type=ResultSetHandler.class, args={Statement.class})})
public class MybatisSqlBeanMapperInterceptor
extends SqlBeanMapper
implements Interceptor {
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public Object intercept(Invocation invocation) throws Throwable {
        Object target = invocation.getTarget();
        if (target instanceof DefaultResultSetHandler) {
            DefaultResultSetHandler resultSetHandler = (DefaultResultSetHandler)target;
            ParameterHandler parameterHandler = (ParameterHandler)ReflectUtil.getFieldValue((Object)resultSetHandler, (String)"parameterHandler");
            MappedStatement mappedStatement = (MappedStatement)ReflectUtil.getFieldValue((Object)resultSetHandler, (String)"mappedStatement");
            if (mappedStatement.getId().startsWith(MybatisSqlBeanDao.class.getName())) {
                Object parameterObj = parameterHandler.getParameterObject();
                List resultMaps = mappedStatement.getResultMaps();
                ResultSetDelegate resultSetDelegate = new ResultSetDelegate((Object)((Statement)invocation.getArgs()[0]).getResultSet());
                return this.handleResultSet((ResultSetDelegate<ResultSet>)resultSetDelegate, (HashMap)parameterObj, ((ResultMap)resultMaps.get(0)).getType());
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private Object handleResultSet(ResultSetDelegate<ResultSet> resultSetDelegate, Map<String, Object> mapParam, Class<?> resultType) {
        if (null != resultSetDelegate.getDelegate()) {
            if (resultType == ColumnInfo.class || resultType == TableInfo.class) {
                return this.beanHandleResultSet((Class)resultType, (ResultSetDelegate)resultSetDelegate, super.getColumnNameList(resultSetDelegate));
            }
            if (SqlBeanUtil.isBaseType(resultType)) {
                return this.baseHandleResultSet(resultSetDelegate, resultType);
            }
            if (SqlBeanUtil.isMap(resultType)) {
                return this.mapHandleResultSet((ResultSetDelegate)resultSetDelegate);
            }
            Class returnType = mapParam.containsKey("returnType") ? (Class)mapParam.get("returnType") : (Class)mapParam.get("clazz");
            if (SqlBeanUtil.isBaseType((Class)returnType)) {
                return this.baseHandleResultSet(resultSetDelegate, returnType);
            }
            if (SqlBeanUtil.isMap((Class)returnType)) {
                return this.mapHandleResultSet((ResultSetDelegate)resultSetDelegate);
            }
            return this.beanHandleResultSet(returnType, (ResultSetDelegate)resultSetDelegate, super.getColumnNameList(resultSetDelegate));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> beanHandleResultSet(Class<?> clazz, ResultSetDelegate<ResultSet> resultSetDelegate, List<String> columnNameList) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        if (null != resultSetDelegate.getDelegate()) {
            try {
                while (((ResultSet)resultSetDelegate.getDelegate()).next()) {
                    resultList.add(super.beanHandleResultSet(clazz, resultSetDelegate, columnNameList));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                this.closeResultSet(resultSetDelegate);
            }
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> mapHandleResultSet(ResultSetDelegate<ResultSet> resultSetDelegate) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        if (null != resultSetDelegate.getDelegate()) {
            try {
                while (((ResultSet)resultSetDelegate.getDelegate()).next()) {
                    resultList.add(super.mapHandleResultSet(resultSetDelegate));
                }
            }
            catch (SQLException e) {
                this.logger.severe(String.format("map\u5bf9\u8c61\u6620\u5c04\u5f02\u5e38SQLException, %s", e.getMessage()));
            }
            finally {
                this.closeResultSet(resultSetDelegate);
            }
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> baseHandleResultSet(ResultSetDelegate<ResultSet> resultSetDelegate, Class<?> returnType) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        if (null != resultSetDelegate.getDelegate()) {
            try {
                while (((ResultSet)resultSetDelegate.getDelegate()).next()) {
                    Object value = super.baseHandleResultSet(resultSetDelegate);
                    if (value != null && value.getClass() != returnType) {
                        value = SqlBeanUtil.getValueConvert(returnType, (Object)value);
                    }
                    resultList.add(value);
                }
            }
            catch (SQLException e) {
                this.logger.severe(String.format("\u57fa\u7840\u5bf9\u8c61\u6620\u5c04\u5f02\u5e38SQLException, %s", e.getMessage()));
            }
            finally {
                this.closeResultSet(resultSetDelegate);
            }
        }
        return resultList;
    }

    private void closeResultSet(ResultSetDelegate<ResultSet> resultSetDelegate) {
        try {
            if (resultSetDelegate.getDelegate() != null) {
                ((ResultSet)resultSetDelegate.getDelegate()).close();
            }
        }
        catch (SQLException e) {
            this.logger.severe(String.format("\u5173\u95ed result set\u5f02\u5e38, %s", e.getMessage()));
        }
    }
}

