/*
 * Decompiled with CFR 0.152.
 */
package co.dapi;

import co.dapi.Auth;
import co.dapi.Config;
import co.dapi.DapiRequest;
import co.dapi.Data;
import co.dapi.Metadata;
import co.dapi.Payment;
import co.dapi.response.CreateBeneficiaryResponse;
import co.dapi.response.CreateTransferResponse;
import co.dapi.response.ExchangeTokenResponse;
import co.dapi.response.GetAccountsMetadataResponse;
import co.dapi.response.GetAccountsResponse;
import co.dapi.response.GetBalanceResponse;
import co.dapi.response.GetBeneficiariesResponse;
import co.dapi.response.GetIdentityResponse;
import co.dapi.response.GetTransactionsResponse;
import co.dapi.response.TransferAutoflowResponse;
import co.dapi.types.UserInput;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.time.LocalDate;
import java.util.HashMap;
import okhttp3.Response;

public class DapiApp {
    private final Config config;
    private final Auth a;
    private final Data d;
    private final Payment p;
    private final Metadata m;

    public DapiApp(Config config) {
        this.config = config;
        this.a = new Auth(config);
        this.d = new Data(config);
        this.p = new Payment(config);
        this.m = new Metadata(config);
    }

    public ExchangeTokenResponse exchangeToken(String accessCode, String connectionID) throws IOException {
        return this.a.exchangeToken(accessCode, connectionID);
    }

    public GetIdentityResponse getIdentity(String accessToken, String userSecret) throws IOException {
        return this.d.getIdentity(accessToken, userSecret, "", null);
    }

    public GetIdentityResponse getIdentity(String accessToken, String userSecret, String operationID, UserInput[] userInputs) throws IOException {
        return this.d.getIdentity(accessToken, userSecret, operationID, userInputs);
    }

    public GetAccountsResponse getAccounts(String accessToken, String userSecret) throws IOException {
        return this.d.getAccounts(accessToken, userSecret, "", null);
    }

    public GetAccountsResponse getAccounts(String accessToken, String userSecret, String operationID, UserInput[] userInputs) throws IOException {
        return this.d.getAccounts(accessToken, userSecret, operationID, userInputs);
    }

    public GetBalanceResponse getBalance(String accountID, String accessToken, String userSecret) throws IOException {
        return this.d.getBalance(accountID, accessToken, userSecret, "", null);
    }

    public GetBalanceResponse getBalance(String accountID, String accessToken, String userSecret, String operationID, UserInput[] userInputs) throws IOException {
        return this.d.getBalance(accountID, accessToken, userSecret, operationID, userInputs);
    }

    public GetTransactionsResponse getTransactions(String accountID, LocalDate fromDate, LocalDate toDate, String accessToken, String userSecret) throws IOException {
        return this.d.getTransactions(accountID, fromDate, toDate, accessToken, userSecret, "", null);
    }

    public GetTransactionsResponse getTransactions(String accountID, LocalDate fromDate, LocalDate toDate, String accessToken, String userSecret, String operationID, UserInput[] userInputs) throws IOException {
        return this.d.getTransactions(accountID, fromDate, toDate, accessToken, userSecret, operationID, userInputs);
    }

    public CreateBeneficiaryResponse createBeneficiary(Payment.BeneficiaryInfo beneficiary, String accessToken, String userSecret) throws IOException {
        return this.p.createBeneficiary(beneficiary, accessToken, userSecret, "", null);
    }

    public CreateBeneficiaryResponse createBeneficiary(Payment.BeneficiaryInfo beneficiary, String accessToken, String userSecret, String operationID, UserInput[] userInputs) throws IOException {
        return this.p.createBeneficiary(beneficiary, accessToken, userSecret, operationID, userInputs);
    }

    public GetBeneficiariesResponse getBeneficiaries(String accessToken, String userSecret) throws IOException {
        return this.p.getBeneficiaries(accessToken, userSecret, "", null);
    }

    public GetBeneficiariesResponse getBeneficiaries(String accessToken, String userSecret, String operationID, UserInput[] userInputs) throws IOException {
        return this.p.getBeneficiaries(accessToken, userSecret, operationID, userInputs);
    }

    public CreateTransferResponse createTransfer(Payment.Transfer transfer, String accessToken, String userSecret) throws IOException {
        return this.p.createTransfer(transfer, accessToken, userSecret, "", null);
    }

    public CreateTransferResponse createTransfer(Payment.Transfer transfer, String accessToken, String userSecret, String operationID, UserInput[] userInputs) throws IOException {
        return this.p.createTransfer(transfer, accessToken, userSecret, operationID, userInputs);
    }

    public TransferAutoflowResponse transferAutoflow(Payment.TransferAutoflow transferAutoflow, String accessToken, String userSecret) throws IOException {
        return this.p.transferAutoflow(transferAutoflow, accessToken, userSecret, "", null);
    }

    public TransferAutoflowResponse transferAutoflow(Payment.TransferAutoflow transferAutoflow, String accessToken, String userSecret, String operationID, UserInput[] userInputs) throws IOException {
        return this.p.transferAutoflow(transferAutoflow, accessToken, userSecret, operationID, userInputs);
    }

    public GetAccountsMetadataResponse getAccountsMetadata(String accessToken, String userSecret) throws IOException {
        return this.m.getAccountsMetadata(accessToken, userSecret, "", null);
    }

    public GetAccountsMetadataResponse getAccountsMetadata(String accessToken, String userSecret, String operationID, UserInput[] userInputs) throws IOException {
        return this.m.getAccountsMetadata(accessToken, userSecret, operationID, userInputs);
    }

    public Response handleSDKRequest(String bodyJson, HashMap<String, String> headersMap) throws IOException, JsonSyntaxException {
        HashMap<String, String> bodyMap = (HashMap<String, String>)DapiRequest.jsonAgent.fromJson(bodyJson, HashMap.class);
        if (bodyMap == null) {
            bodyMap = new HashMap<String, String>();
        }
        bodyMap.put("appSecret", this.config.getAppSecret());
        bodyJson = DapiRequest.jsonAgent.toJson(bodyMap);
        return DapiRequest.HandleSDK(bodyJson, headersMap);
    }

    public Response handleSDKRequest(String bodyJson) throws IOException, JsonSyntaxException {
        return this.handleSDKRequest(bodyJson, new HashMap<String, String>());
    }

    public Response handleSecureSDKRequest(String bodyJson, HashMap<String, String> headersMap) throws IOException, JsonSyntaxException {
        HashMap<String, String> bodyMap = (HashMap<String, String>)DapiRequest.jsonAgent.fromJson(bodyJson, HashMap.class);
        if (bodyMap == null) {
            bodyMap = new HashMap<String, String>();
        }
        bodyMap.put("appSecret", this.config.getAppSecret());
        bodyJson = DapiRequest.jsonAgent.toJson(bodyMap);
        return DapiRequest.HandleSecureSDK(bodyJson, headersMap);
    }

    public Response handleSecureSDKRequest(String bodyJson) throws IOException, JsonSyntaxException {
        return this.handleSecureSDKRequest(bodyJson, new HashMap<String, String>());
    }
}

