/*
 * Decompiled with CFR 0.152.
 */
package co.dapi;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;

class TimeoutInterceptor
implements Interceptor {
    Gson jsonAgent;
    public static final int MAX_TIMEOUT = 300;
    public static final int MIN_TIMEOUT = 135;
    public static final String CREATE_TRANSFER = "payment/transfer/autoflow";
    public static final String CREATE_TRANSFER_TO_EXISTING_BENEFICIARY = "payment/transfer/create";
    public static final String CREATE_WIRE_TRANSFER = "wire/transfer/autoflow";
    public static final String CREATE_WIRE_TRANSFER_TO_EXISTING_BENEFICIARY = "wire/transfer/create";
    public static final String CREATE_ACH_PULL_TRANSFER = "ach/pull/create";
    public static final String NYMCARD_LOAD_FUNDS = "nymcard/funds/load";
    private static final String[] maxTimeoutEndpoints = new String[]{"payment/transfer/autoflow", "payment/transfer/create", "wire/transfer/autoflow", "wire/transfer/create", "ach/pull/create", "nymcard/funds/load"};

    public static boolean maxTimeoutEnabled(String endpoint) {
        for (String maxTimeoutEndpoint : maxTimeoutEndpoints) {
            if (!endpoint.contains(maxTimeoutEndpoint)) continue;
            return true;
        }
        return false;
    }

    private static String stringify(Request request) {
        try {
            Request copy = request.newBuilder().build();
            Buffer buffer = new Buffer();
            copy.body().writeTo((BufferedSink)buffer);
            return buffer.readUtf8();
        }
        catch (IOException e) {
            return null;
        }
    }

    public TimeoutInterceptor(Gson jsonAgent) {
        this.jsonAgent = jsonAgent;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        HashMap bodyMap = (HashMap)this.jsonAgent.fromJson(TimeoutInterceptor.stringify(request), HashMap.class);
        int timeout = bodyMap.containsKey("action") && TimeoutInterceptor.maxTimeoutEnabled(bodyMap.get("action").toString()) ? 300 : 135;
        return chain.withReadTimeout(timeout, TimeUnit.SECONDS).withConnectTimeout(timeout, TimeUnit.SECONDS).withWriteTimeout(timeout, TimeUnit.SECONDS).proceed(request);
    }
}

