/*
 * Decompiled with CFR 0.152.
 */
package io.ipdata.client;

import io.ipdata.client.Ipdata;
import io.ipdata.client.service.CacheConfig;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class CacheConfigBuilder {
    private final Ipdata.Builder parent;
    private long maxSize;
    private int timeout;
    private TimeUnit unit;

    public CacheConfigBuilder maxSize(long maxSize) {
        if (maxSize <= 0L) {
            throw new IllegalArgumentException("cache size must be greater than 0");
        }
        this.maxSize = maxSize;
        return this;
    }

    public CacheConfigBuilder timeout(int timeout, TimeUnit unit) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("cache timeout must be greater than 0");
        }
        if (unit == null) {
            throw new IllegalArgumentException("timeout unit should not be null");
        }
        this.timeout = timeout;
        this.unit = unit;
        return this;
    }

    public Ipdata.Builder registerCacheConfig() {
        return this.parent.cacheConfig(CacheConfig.builder().maxSize(this.maxSize).timeout(this.timeout).unit(this.unit).build());
    }

    @Generated
    CacheConfigBuilder(Ipdata.Builder parent) {
        this.parent = parent;
    }
}

