/*
 * Decompiled with CFR 0.152.
 */
package io.ipdata.client.service;

import com.google.common.base.Joiner;
import io.ipdata.client.error.IpdataException;
import io.ipdata.client.model.AsnModel;
import io.ipdata.client.model.Currency;
import io.ipdata.client.model.IpdataModel;
import io.ipdata.client.model.ThreatModel;
import io.ipdata.client.model.TimeZone;
import io.ipdata.client.service.IpdataField;
import io.ipdata.client.service.IpdataInternalClient;
import io.ipdata.client.service.IpdataInternalSingleFieldClient;
import io.ipdata.client.service.IpdataService;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IpdataServiceSupport
implements IpdataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IpdataServiceSupport.class);
    private static final IpdataField.IpdataFieldComparator COMPARATOR = new IpdataField.IpdataFieldComparator();
    private static final String SEPARATOR = ",";
    private final IpdataInternalClient api;
    private final IpdataInternalSingleFieldClient singleFieldClient;

    public IpdataInternalClient getSingleFieldClient() {
        return this.api;
    }

    private IpdataInternalSingleFieldClient getApi() {
        return this.singleFieldClient;
    }

    @Override
    public IpdataModel[] bulkAsArray(List<String> ips) throws IpdataException {
        return this.bulk(ips).toArray(new IpdataModel[0]);
    }

    @Override
    public IpdataModel getFields(String ip, IpdataField<?> ... fields) throws IpdataException {
        if (fields.length == 0) {
            return null;
        }
        Arrays.sort(fields, COMPARATOR);
        return this.api.getFields(ip, Joiner.on((String)SEPARATOR).join(Arrays.asList(fields)));
    }

    @Generated
    public static IpdataServiceSupportBuilder builder() {
        return new IpdataServiceSupportBuilder();
    }

    @Generated
    public IpdataServiceSupport(IpdataInternalClient api, IpdataInternalSingleFieldClient singleFieldClient) {
        this.api = api;
        this.singleFieldClient = singleFieldClient;
    }

    @Override
    @Generated
    public IpdataModel ipdata(String ip) throws IpdataException {
        return this.getSingleFieldClient().ipdata(ip);
    }

    @Override
    @Generated
    public List<IpdataModel> bulk(List<String> ips) throws IpdataException {
        return this.getSingleFieldClient().bulk(ips);
    }

    @Generated
    public IpdataModel getFields(String ip, String fields) throws IpdataException {
        return this.getSingleFieldClient().getFields(ip, fields);
    }

    @Override
    @Generated
    public String getIp(String ip) throws IpdataException {
        return this.getApi().getIp(ip);
    }

    @Override
    @Generated
    public boolean isEu(String ip) throws IpdataException {
        return this.getApi().isEu(ip);
    }

    @Override
    @Generated
    public String getCity(String ip) throws IpdataException {
        return this.getApi().getCity(ip);
    }

    @Override
    @Generated
    public String getCountryName(String ip) throws IpdataException {
        return this.getApi().getCountryName(ip);
    }

    @Override
    @Generated
    public String getCountryCode(String ip) throws IpdataException {
        return this.getApi().getCountryCode(ip);
    }

    @Override
    @Generated
    public String getContinentCode(String ip) throws IpdataException {
        return this.getApi().getContinentCode(ip);
    }

    @Override
    @Generated
    public double getLongitude(String ip) throws IpdataException {
        return this.getApi().getLongitude(ip);
    }

    @Override
    @Generated
    public double getLatitude(String ip) throws IpdataException {
        return this.getApi().getLatitude(ip);
    }

    @Override
    @Generated
    public String getOrganisation(String ip) throws IpdataException {
        return this.getApi().getOrganisation(ip);
    }

    @Override
    @Generated
    public String getPostal(String ip) throws IpdataException {
        return this.getApi().getPostal(ip);
    }

    @Override
    @Generated
    public String getCallingCode(String ip) throws IpdataException {
        return this.getApi().getCallingCode(ip);
    }

    @Override
    @Generated
    public String getFlag(String ip) throws IpdataException {
        return this.getApi().getFlag(ip);
    }

    @Override
    @Generated
    public String getEmojiFlag(String ip) throws IpdataException {
        return this.getApi().getEmojiFlag(ip);
    }

    @Override
    @Generated
    public String getEmojiUnicode(String ip) throws IpdataException {
        return this.getApi().getEmojiUnicode(ip);
    }

    @Override
    @Generated
    public AsnModel asn(String ip) throws IpdataException {
        return this.getApi().asn(ip);
    }

    @Override
    @Generated
    public TimeZone timeZone(String ip) throws IpdataException {
        return this.getApi().timeZone(ip);
    }

    @Override
    @Generated
    public Currency currency(String ip) throws IpdataException {
        return this.getApi().currency(ip);
    }

    @Override
    @Generated
    public ThreatModel threat(String ip) throws IpdataException {
        return this.getApi().threat(ip);
    }

    @Generated
    public static class IpdataServiceSupportBuilder {
        @Generated
        private IpdataInternalClient api;
        @Generated
        private IpdataInternalSingleFieldClient singleFieldClient;

        @Generated
        IpdataServiceSupportBuilder() {
        }

        @Generated
        public IpdataServiceSupportBuilder api(IpdataInternalClient api) {
            this.api = api;
            return this;
        }

        @Generated
        public IpdataServiceSupportBuilder singleFieldClient(IpdataInternalSingleFieldClient singleFieldClient) {
            this.singleFieldClient = singleFieldClient;
            return this;
        }

        @Generated
        public IpdataServiceSupport build() {
            return new IpdataServiceSupport(this.api, this.singleFieldClient);
        }

        @Generated
        public String toString() {
            return "IpdataServiceSupport.IpdataServiceSupportBuilder(api=" + this.api + ", singleFieldClient=" + this.singleFieldClient + ")";
        }
    }
}

