/*
 * Decompiled with CFR 0.152.
 */
package code316.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class Args {
    private static final String SWITCH_CHAR = "-";

    public static Properties parse(String[] args, int offset, int length) {
        if (args == null) {
            return null;
        }
        Properties props = new Properties();
        if (length == 0) {
            return props;
        }
        if (offset >= length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ArrayList<Argument> parsed = new ArrayList<Argument>();
        Argument arg = null;
        int i = offset;
        while (i < length) {
            String a = args[i].trim();
            if (a.startsWith(SWITCH_CHAR)) {
                String name = a.substring(1);
                arg = new Argument(name);
                parsed.add(arg);
                props.put(arg.getName(), arg.getValue());
            } else if (arg == null) {
                System.err.println("ignoring argument with no '-'");
            } else {
                arg.addValue(a);
                Iterator tor = parsed.iterator();
                while (tor.hasNext()) {
                    Argument key = (Argument)tor.next();
                    if (arg.valCount == 1) {
                        props.put(arg.getName(), arg.getValue());
                        continue;
                    }
                    props.put(arg.getName(), arg.getValues());
                }
            }
            ++i;
        }
        return props;
    }

    public static Properties parse(String[] args) {
        if (args == null) {
            return null;
        }
        return Args.parse(args, 0, args.length);
    }

    static class Argument {
        private String name;
        private String[] vals = new String[]{""};
        private short valCount = 0;

        public Argument(String name) {
            if (name == null) {
                throw new IllegalArgumentException("invalid value for name: " + name);
            }
            this.name = name;
        }

        public Argument(String name, String value) {
            this(name);
            this.addValue(value);
        }

        public void addValue(String val) {
            if (this.valCount == this.vals.length) {
                String[] na = new String[this.vals.length + 1];
                System.arraycopy(this.vals, 0, na, 0, this.vals.length);
                this.vals = na;
            }
            this.vals[this.valCount] = val;
            this.valCount = (short)(this.valCount + 1);
        }

        public String getValue() {
            return this.vals[0];
        }

        public String[] getValues() {
            return this.vals;
        }

        public String getValueString() {
            StringBuffer line = new StringBuffer();
            int i = 0;
            while (i < this.vals.length) {
                line.append(this.vals[i]).append(" ");
                ++i;
            }
            return line.toString().trim();
        }

        public int valueCount() {
            return this.valCount;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuffer me = new StringBuffer();
            me.append("[").append(super.toString()).append(",vals=").append(this.vals).append(",valCount=").append(this.valCount).append(",name=").append(this.name).append("]");
            return me.toString();
        }
    }
}

