/*
 * Decompiled with CFR 0.152.
 */
package code316.core;

import code316.core.Category;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;

public class DbHelper {
    private ArrayList connections = new ArrayList();
    private ArrayList statements = new ArrayList();
    private ArrayList resultSets = new ArrayList();
    private boolean suppress = true;
    private boolean silent = false;
    private Category log = new Category(class$code316$core$DbHelper == null ? (class$code316$core$DbHelper = DbHelper.class$("code316.core.DbHelper")) : class$code316$core$DbHelper);
    static /* synthetic */ Class class$code316$core$DbHelper;

    public DbHelper() {
        this.log.setLogLevel(10);
    }

    public void closeAll() {
        Exception resultsException = null;
        Exception statementsException = null;
        Exception connectionsException = null;
        Iterator tor = this.resultSets.iterator();
        while (tor.hasNext()) {
            ResultSet rs = (ResultSet)tor.next();
            try {
                this.log.debug("closing resultset: " + rs);
                rs.close();
                this.log.debug("closed resultset: " + rs);
            }
            catch (Exception e) {
                e.printStackTrace();
                resultsException = e;
            }
        }
        tor = this.statements.iterator();
        while (tor.hasNext()) {
            Statement statement = (Statement)tor.next();
            try {
                this.log.debug("closing statement: " + statement);
                statement.close();
                this.log.debug("closed statement: " + statement);
            }
            catch (Exception e) {
                e.printStackTrace();
                statementsException = e;
            }
        }
        tor = this.connections.iterator();
        while (tor.hasNext()) {
            Connection connection = (Connection)tor.next();
            try {
                this.log.debug("closing connection: " + connection);
                connection.close();
                this.log.debug("closed connection: " + connection);
            }
            catch (Exception e) {
                e.printStackTrace();
                connectionsException = e;
            }
        }
    }

    private void closeConnections() {
        Iterator tor = this.connections.iterator();
        while (tor.hasNext()) {
            Connection connection = (Connection)tor.next();
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void closeResultSets() {
        Iterator tor = this.resultSets.iterator();
        while (tor.hasNext()) {
            ResultSet rs = (ResultSet)tor.next();
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void closeStatements() {
        Iterator tor = this.statements.iterator();
        while (tor.hasNext()) {
            Statement statement = (Statement)tor.next();
            try {
                statement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public Connection addConnection(Connection connection) {
        if (connection == null) {
            throw new NullPointerException("connection can not be null");
        }
        this.connections.add(connection);
        return connection;
    }

    public PreparedStatement addPreparedStatement(PreparedStatement statement) {
        return (PreparedStatement)this.addStatement(statement);
    }

    public ResultSet addResultSet(ResultSet resultSet) {
        if (resultSet == null) {
            throw new NullPointerException("resultSet can not be null");
        }
        this.resultSets.add(resultSet);
        return resultSet;
    }

    public Statement addStatement(Statement statement) {
        if (statement == null) {
            throw new NullPointerException("statement can not be null");
        }
        this.statements.add(statement);
        return statement;
    }

    public static void close(Connection connection) throws SQLException {
        if (connection == null) {
            return;
        }
        connection.close();
    }

    public static void closeQuietly(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void close(Statement statement) throws SQLException {
        if (statement == null) {
            return;
        }
        statement.close();
    }

    public static void closeQuietly(Statement stmt) {
        if (stmt == null) {
            return;
        }
        try {
            stmt.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void close(ResultSet rs) throws SQLException {
        if (rs == null) {
            return;
        }
        rs.close();
    }

    public static void closeQuietly(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void close(Connection connection, Statement statement, ResultSet rs) throws SQLException {
        DbHelper.close(rs);
        DbHelper.close(statement);
        DbHelper.close(connection);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

