/*
 * Decompiled with CFR 0.152.
 */
package code316.core;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FileUtil {
    private static volatile int fileIndex = 1;

    public static String getUnusedFileName(String path, String seed, String extension) throws IOException {
        File file = null;
        path = FileUtil.endPath(path);
        while ((file = new File(path + seed + fileIndex + extension)).exists()) {
            ++fileIndex;
        }
        return file.getAbsolutePath();
    }

    public static List getChildren(String path) throws FileNotFoundException {
        return FileUtil.getChildren(new File(path));
    }

    public static List getChildrenWithExtension(String path, String extension) throws FileNotFoundException {
        List children = FileUtil.getChildren(new File(path));
        ArrayList<File> selected = new ArrayList<File>();
        Iterator tor = children.iterator();
        while (tor.hasNext()) {
            File file = (File)tor.next();
            if (!file.toString().endsWith(extension)) continue;
            selected.add(file);
        }
        return selected;
    }

    public static List getChildren(File path) throws FileNotFoundException {
        if (path == null) {
            throw new IllegalArgumentException("invalid value for path: " + path);
        }
        if (!path.isDirectory()) {
            throw new IllegalArgumentException(path + " is not a directory");
        }
        ArrayList<File> children = new ArrayList<File>();
        File[] files = path.listFiles();
        int i = 0;
        while (i < files.length) {
            children.add(files[i]);
            ++i;
        }
        return children;
    }

    public static List getChildDirectories(String path) throws FileNotFoundException {
        return FileUtil.getChildDirectories(new File(path));
    }

    public static List getChildDirectories(File path) throws FileNotFoundException {
        List children = FileUtil.getChildren(path);
        ArrayList<File> directories = new ArrayList<File>();
        Iterator tor = children.iterator();
        while (tor.hasNext()) {
            File file = (File)tor.next();
            if (!file.isDirectory()) continue;
            directories.add(file);
        }
        return directories;
    }

    public static void writeToFile(String content, String fileName) throws IOException {
        FileOutputStream out = new FileOutputStream(fileName);
        out.write(content.getBytes());
        out.close();
    }

    public static String loadTextFile(String fileName) throws IOException {
        return new String(FileUtil.loadFile(fileName));
    }

    public static byte[] loadFile(String fileName, ClassLoader loader) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("invalid value for fileName: " + fileName);
        }
        InputStream in = FileUtil.getFileAsStream(fileName, loader);
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
        in.close();
        return out.toByteArray();
    }

    public static byte[] loadFile(String fileName) throws IOException {
        return FileUtil.loadFile(fileName, null);
    }

    public static String[] loadLines(String fileName) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        ArrayList<String> lines = new ArrayList<String>();
        String line = null;
        while ((line = in.readLine()) != null) {
            lines.add(line.trim());
        }
        return lines.toArray(new String[lines.size()]);
    }

    public static String getSafeFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        fileName = fileName.toLowerCase();
        int count = fileName.length();
        int maxLength = 128;
        char[] buffer = new char[count];
        fileName.getChars(0, count, buffer, 0);
        if (maxLength > buffer.length) {
            maxLength = buffer.length;
        }
        boolean changed = false;
        int i = 0;
        while (i < maxLength) {
            char ch = buffer[i];
            if (!(ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z')) {
                buffer[i] = 95;
                changed = true;
            }
            ++i;
        }
        if (changed) {
            fileName = new String(buffer, 0, maxLength);
        }
        return fileName;
    }

    public static String getExtension(String fileName) {
        return FileUtil.getExtension(fileName, ".");
    }

    public static String getExtension(String fileName, String extensionSeparator) {
        if (fileName == null) {
            return null;
        }
        int pos = fileName.lastIndexOf(extensionSeparator);
        return pos != -1 && pos < fileName.length() ? fileName.substring(pos + 1) : "";
    }

    public static String endPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("invalid value for path: " + path);
        }
        if (path.endsWith(File.separator)) {
            return path;
        }
        return path + File.separator;
    }

    public static InputStream getFileAsStream(String name) throws FileNotFoundException {
        return FileUtil.getFileAsStream(name, null);
    }

    public static InputStream getFileAsStream(String name, ClassLoader loader) throws FileNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("invalid value for name: " + name);
        }
        FileNotFoundException e = null;
        InputStream in = null;
        try {
            return new FileInputStream(name);
        }
        catch (FileNotFoundException fnfe) {
            e = fnfe;
            System.out.println("loader: " + loader);
            in = loader == null ? ClassLoader.getSystemResourceAsStream(name) : loader.getResourceAsStream(name);
            if (in == null) {
                throw e;
            }
            return in;
        }
    }
}

