/*
 * Decompiled with CFR 0.152.
 */
package code316.core;

import code316.core.FileUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public class PropertiesUtil {
    private static HashMap bundles = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProperty(String propertiesFile, String propertyName) {
        if (propertiesFile == null || propertyName == null) {
            return null;
        }
        HashMap hashMap = bundles;
        synchronized (hashMap) {
            Properties props = (Properties)bundles.get(propertiesFile);
            if (props == null) {
                try {
                    props = PropertiesUtil.loadPropertiesFromFile(propertiesFile);
                    bundles.put(propertiesFile, props);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException("could not load properties: " + e);
                }
            }
            return (String)props.get(propertyName);
        }
    }

    public static Properties loadPropertiesFromFile(String fileName) throws IOException {
        Properties props = new Properties();
        InputStream in = FileUtil.getFileAsStream(fileName);
        props.load(in);
        in.close();
        return props;
    }

    public static void storeProperties(Properties properties, String fileName) throws IOException {
        PropertiesUtil.storeProperties(properties, fileName, null);
    }

    public static void storeProperties(Properties properties, String fileName, String header) throws IOException {
        if (properties == null || fileName == null) {
            return;
        }
        FileOutputStream out = new FileOutputStream(fileName);
        properties.store(out, header);
        out.close();
    }

    public static boolean isEmpty(Object[] value) {
        return value == null || value.length == 0;
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static Properties filter(Properties props, String filter) {
        Properties filtered = new Properties();
        Iterator<Object> tor = props.keySet().iterator();
        while (tor.hasNext()) {
            String key = (String)tor.next();
            if (!key.startsWith(filter)) continue;
            Object value = props.get(key);
            filtered.put(key, value);
        }
        return filtered;
    }
}

