/*
 * Decompiled with CFR 0.152.
 */
package code316.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class FileMaskFilter
implements FilenameFilter {
    public static final String FILE_MASK_SEPARATOR = ",";
    protected String fileMask = "*.*";
    protected boolean acceptAllFiles;
    protected boolean accepting = true;
    protected int maxFiles;
    protected int accepted;
    protected ArrayList masks = new ArrayList();

    public FileMaskFilter(String fileMask) {
        this.setFileMask(fileMask);
    }

    public String getFileMask() {
        return this.fileMask;
    }

    public boolean isAcceptAllFiles() {
        return this.acceptAllFiles;
    }

    public void setAcceptAllFiles(boolean newAcceptAllFiles) {
        this.acceptAllFiles = newAcceptAllFiles;
    }

    public boolean accept(File dir, String name) {
        if (!this.accepting) {
            return false;
        }
        boolean accept = false;
        if (this.acceptAllFiles || this.fileMatchesMask(name)) {
            ++this.accepted;
            accept = true;
            if (this.accepted == this.maxFiles) {
                this.accepting = false;
            }
        }
        return accept;
    }

    private void addFileMask(String newFileMask) {
        this.fileMask = newFileMask;
        if (this.fileMask.equals("*.*")) {
            this.acceptAllFiles = true;
        }
        if (this.fileMask.startsWith("*.")) {
            this.fileMask = this.fileMask.substring(1);
        }
        this.masks.add(this.fileMask);
    }

    private boolean fileMatchesMask(String name) {
        boolean matches = false;
        int count = this.masks.size();
        int i = 0;
        while (i < count) {
            String mask = (String)this.masks.get(i);
            if (name.endsWith(mask)) {
                matches = true;
                break;
            }
            ++i;
        }
        return matches;
    }

    public int getAccepted() {
        return this.accepted;
    }

    public int getMaxFiles() {
        return this.maxFiles;
    }

    public boolean isAccepting() {
        return this.accepting;
    }

    public void reset() {
        this.accepted = 0;
        this.accepting = true;
    }

    public void setFileMask(String fileMask) {
        if (fileMask == null || fileMask.trim().length() == 0) {
            throw new IllegalArgumentException("invalid fileMask value: " + fileMask);
        }
        this.fileMask = fileMask.trim();
        this.reset();
        this.masks.clear();
        if (fileMask.indexOf(FILE_MASK_SEPARATOR) == -1) {
            this.addFileMask(fileMask);
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(fileMask, FILE_MASK_SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            this.addFileMask(tokenizer.nextToken().trim());
        }
    }

    public void setMaxFiles(int newMaxFiles) {
        this.maxFiles = newMaxFiles;
    }
}

