/*
 * Decompiled with CFR 0.152.
 */
package com.abasecode.opencode.base.token;

import com.abasecode.opencode.base.code.CodeException;
import com.abasecode.opencode.base.token.config.TokenConfig;
import com.abasecode.opencode.base.token.entity.Token;
import com.abasecode.opencode.base.token.entity.TokenInfo;
import com.abasecode.opencode.base.token.entity.TokenUser;
import com.abasecode.opencode.base.token.util.CodeRedisUtils;
import com.abasecode.opencode.base.token.util.TokenKeysUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;
import java.util.Set;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class TokenHandler {
    private static final Logger log = LoggerFactory.getLogger(TokenHandler.class);
    @Autowired
    CodeRedisUtils codeRedisUtils;
    @Autowired
    TokenConfig.ApiToken apiToken;

    public TokenUser getUser() {
        TokenUser user = (TokenUser)SecurityUtils.getSubject().getPrincipal();
        return user;
    }

    public TokenUser getUser(String token) {
        TokenInfo tokenInfo = this.getTokenInfoByClaim(token);
        Object oo = this.codeRedisUtils.getObject(TokenKeysUtils.getUserKey(tokenInfo.getAppKey(), tokenInfo.getUserId()));
        TokenUser user = (TokenUser)JSONObject.parseObject((String)oo.toString(), TokenUser.class);
        return user;
    }

    public Set<String> getUserPermission(String token) {
        TokenInfo tokenInfo = this.getTokenInfoByClaim(token);
        Object oo = this.codeRedisUtils.getObject(TokenKeysUtils.getPermissionKey(tokenInfo.getAppKey(), tokenInfo.getUserId()));
        return (Set)JSONObject.parseObject((String)oo.toString(), Set.class);
    }

    public Set<String> getUserRole(String token) {
        TokenInfo tokenInfo = this.getTokenInfoByClaim(token);
        Object oo = this.codeRedisUtils.getObject(TokenKeysUtils.getRolesKey(tokenInfo.getAppKey(), tokenInfo.getUserId()));
        return (Set)JSONObject.parseObject((String)oo.toString(), Set.class);
    }

    public Token getToken(String baseKey, TokenUser user) {
        Object o = this.codeRedisUtils.getObject(TokenKeysUtils.getTokenKey(baseKey, user));
        return (Token)JSON.parseObject((String)o.toString(), Token.class);
    }

    public Token getToken(TokenUser user) {
        return this.getToken(this.apiToken.getKey(), user);
    }

    public Token createToken(TokenUser user) {
        String baseKey = this.apiToken.getKey();
        return this.generateToken(baseKey, user, false);
    }

    public Token createToken(TokenUser user, String baseKey) {
        return this.generateToken(baseKey, user, true);
    }

    public boolean cleanToken(String token, TokenUser user) throws Exception {
        String baseKey = this.apiToken.getKey();
        return this.destroyToken(token, user, baseKey);
    }

    public boolean cleanToken(String token, TokenUser user, String baseKey) throws Exception {
        return this.destroyToken(token, user, baseKey);
    }

    public Claims getClaimByToken(String token) {
        try {
            return (Claims)Jwts.parser().setSigningKey(this.apiToken.getSecret()).parseClaimsJws(token).getBody();
        }
        catch (CodeException e) {
            log.debug("Token error!", (Throwable)e);
            throw new CodeException("Token error!", HttpStatus.SERVICE_UNAVAILABLE.value());
        }
    }

    public TokenInfo getTokenInfoByClaim(String token) {
        try {
            String[] strings = this.getClaimByToken(token).getSubject().split("\\|");
            TokenInfo tokenInfo = new TokenInfo().setUserId(Integer.parseInt(strings[1])).setAppKey(strings[0]);
            return tokenInfo;
        }
        catch (Exception e) {
            log.debug("Token error!", (Throwable)e);
            throw new CodeException("Token error!", HttpStatus.SERVICE_UNAVAILABLE.value());
        }
    }

    public boolean isTokenExpired(Date expiration) {
        return expiration.before(new Date());
    }

    public boolean isTokenExpired(String token) {
        Date expiration = this.getClaimByToken(token).getExpiration();
        return this.isTokenExpired(expiration);
    }

    private boolean checkToken(String token) {
        String baseKey = this.apiToken.getKey();
        TokenInfo tokenInfo = this.getTokenInfoByClaim(token);
        Object oo = this.codeRedisUtils.getObject(TokenKeysUtils.getUserKey(tokenInfo.getAppKey(), tokenInfo.getUserId()));
        return oo != null;
    }

    private Token generateToken(String baseKey, TokenUser user, boolean hasSimple) {
        Date date1 = new Date();
        Date expireDate = new Date(date1.getTime() + this.apiToken.getExpire() * 1000L);
        String tokenString = Jwts.builder().setHeaderParam("type", (Object)"JWT").setSubject(baseKey + "|" + user.getUserId()).setIssuedAt(date1).setExpiration(expireDate).signWith(SignatureAlgorithm.HS512, this.apiToken.getSecret()).compact();
        Token token = new Token();
        token.setToken(tokenString);
        token.setExpire(this.apiToken.getExpire() * 1000L);
        try {
            this.saveToken(baseKey, user, token);
            if (!hasSimple) {
                this.saveLoginInfo(baseKey, user, user.getUserPermissionSet(), user.getUserRolesSet());
            } else {
                this.saveLoginInfo(baseKey, user);
            }
        }
        catch (Exception e) {
            throw new CodeException("Redis server error.", HttpStatus.SERVICE_UNAVAILABLE.value());
        }
        return token;
    }

    private void saveLoginInfo(String baseKey, TokenUser user, Set<String> userPermissionSet, Set<String> userRolesSet) {
        this.codeRedisUtils.saveObject(TokenKeysUtils.getUserKey(baseKey, user), user);
        this.codeRedisUtils.saveObject(TokenKeysUtils.getPermissionKey(baseKey, user), userPermissionSet);
        this.codeRedisUtils.saveObject(TokenKeysUtils.getRolesKey(baseKey, user), userRolesSet);
    }

    private void saveLoginInfo(String baseKey, TokenUser user) {
        this.codeRedisUtils.saveObject(TokenKeysUtils.getUserKey(baseKey, user), user);
    }

    private void saveToken(String baseKey, TokenUser user, Token token) {
        this.codeRedisUtils.saveObject(TokenKeysUtils.getTokenKey(baseKey, user), token);
    }

    private boolean destroyToken(String token, TokenUser user, String baseKey) {
        Token token1 = this.getToken(baseKey, user);
        if (token1.getToken().equals(token)) {
            this.codeRedisUtils.delObject(TokenKeysUtils.getTokenKey(baseKey, user));
            return true;
        }
        return false;
    }
}

