package com.abasecode.opencode.base.toolkit.qrcode.entity;

/**
 * @author: Jon So
 * url: <a href="https://github.com/abasecode">github</a>
 * url: <a href="https://abasecode.com">AbaseCode.com</a>
 */
public final class QrConfig {
    private static final int CODE_LENGTH_DEFAULT = 300;
    private static final int CODE_LENGTH_MIN = 80;
    private static final int COLOR_FRONT = 0xFF000000;
    private static final int COLOR_BACKGROUND = 0xFFFFFFFF;

    private int codeLength;
    private int colorFront;
    private int colorBackground;

    public QrConfig() {
        this(CODE_LENGTH_DEFAULT, COLOR_FRONT, COLOR_BACKGROUND);
    }

    public QrConfig(int length, int colorFront, int colorBackground) {
        if (length <= CODE_LENGTH_MIN) {
            length = CODE_LENGTH_DEFAULT;
        }
        this.codeLength = length;
        this.colorFront = colorFront;
        this.colorBackground = colorBackground;
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public int getColorFront() {
        return this.colorFront;
    }

    public int getColorBackground() {
        return this.colorBackground;
    }
}