/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeartifact.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.codeartifact.model.PackageFormat;
import com.amazonaws.services.codeartifact.model.PackageVersionSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListPackageVersionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String defaultDisplayVersion;
    private String format;
    private String namespace;
    private String packageValue;
    private List<PackageVersionSummary> versions;
    private String nextToken;

    public void setDefaultDisplayVersion(String defaultDisplayVersion) {
        this.defaultDisplayVersion = defaultDisplayVersion;
    }

    public String getDefaultDisplayVersion() {
        return this.defaultDisplayVersion;
    }

    public ListPackageVersionsResult withDefaultDisplayVersion(String defaultDisplayVersion) {
        this.setDefaultDisplayVersion(defaultDisplayVersion);
        return this;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public ListPackageVersionsResult withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public ListPackageVersionsResult withFormat(PackageFormat format) {
        this.format = format.toString();
        return this;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ListPackageVersionsResult withNamespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public void setPackage(String packageValue) {
        this.packageValue = packageValue;
    }

    public String getPackage() {
        return this.packageValue;
    }

    public ListPackageVersionsResult withPackage(String packageValue) {
        this.setPackage(packageValue);
        return this;
    }

    public List<PackageVersionSummary> getVersions() {
        return this.versions;
    }

    public void setVersions(Collection<PackageVersionSummary> versions) {
        if (versions == null) {
            this.versions = null;
            return;
        }
        this.versions = new ArrayList<PackageVersionSummary>(versions);
    }

    public ListPackageVersionsResult withVersions(PackageVersionSummary ... versions) {
        if (this.versions == null) {
            this.setVersions(new ArrayList<PackageVersionSummary>(versions.length));
        }
        for (PackageVersionSummary ele : versions) {
            this.versions.add(ele);
        }
        return this;
    }

    public ListPackageVersionsResult withVersions(Collection<PackageVersionSummary> versions) {
        this.setVersions(versions);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListPackageVersionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDefaultDisplayVersion() != null) {
            sb.append("DefaultDisplayVersion: ").append(this.getDefaultDisplayVersion()).append(",");
        }
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat()).append(",");
        }
        if (this.getNamespace() != null) {
            sb.append("Namespace: ").append(this.getNamespace()).append(",");
        }
        if (this.getPackage() != null) {
            sb.append("Package: ").append(this.getPackage()).append(",");
        }
        if (this.getVersions() != null) {
            sb.append("Versions: ").append(this.getVersions()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPackageVersionsResult)) {
            return false;
        }
        ListPackageVersionsResult other = (ListPackageVersionsResult)obj;
        if (other.getDefaultDisplayVersion() == null ^ this.getDefaultDisplayVersion() == null) {
            return false;
        }
        if (other.getDefaultDisplayVersion() != null && !other.getDefaultDisplayVersion().equals(this.getDefaultDisplayVersion())) {
            return false;
        }
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        if (other.getFormat() != null && !other.getFormat().equals(this.getFormat())) {
            return false;
        }
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getPackage() == null ^ this.getPackage() == null) {
            return false;
        }
        if (other.getPackage() != null && !other.getPackage().equals(this.getPackage())) {
            return false;
        }
        if (other.getVersions() == null ^ this.getVersions() == null) {
            return false;
        }
        if (other.getVersions() != null && !other.getVersions().equals(this.getVersions())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDefaultDisplayVersion() == null ? 0 : this.getDefaultDisplayVersion().hashCode());
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getPackage() == null ? 0 : this.getPackage().hashCode());
        hashCode = 31 * hashCode + (this.getVersions() == null ? 0 : this.getVersions().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListPackageVersionsResult clone() {
        try {
            return (ListPackageVersionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

