/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.ui.widget;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import com.androidplot.ui.AnchorPosition;
import com.androidplot.ui.LayoutManager;
import com.androidplot.ui.SizeLayoutType;
import com.androidplot.ui.SizeMetrics;
import com.androidplot.ui.TextOrientationType;
import com.androidplot.ui.widget.Widget;
import com.androidplot.util.FontUtils;

public class TextLabelWidget
extends Widget {
    private static final String TAG = TextLabelWidget.class.getName();
    private String text;
    private Paint labelPaint = new Paint();
    private TextOrientationType orientation;
    private boolean autoPackEnabled = true;

    public TextLabelWidget(LayoutManager layoutManager, SizeMetrics sizeMetrics) {
        this(layoutManager, sizeMetrics, TextOrientationType.HORIZONTAL);
    }

    public TextLabelWidget(LayoutManager layoutManager, String title, SizeMetrics sizeMetrics, TextOrientationType orientation) {
        this(layoutManager, sizeMetrics, orientation);
        this.setText(title);
    }

    public TextLabelWidget(LayoutManager layoutManager, SizeMetrics sizeMetrics, TextOrientationType orientation) {
        super(layoutManager, new SizeMetrics(0.0f, SizeLayoutType.ABSOLUTE, 0.0f, SizeLayoutType.ABSOLUTE));
        this.labelPaint.setColor(-1);
        this.labelPaint.setAntiAlias(true);
        this.labelPaint.setTextAlign(Paint.Align.CENTER);
        this.setSize(sizeMetrics);
        this.orientation = orientation;
    }

    @Override
    protected void onMetricsChanged(SizeMetrics olds, SizeMetrics news) {
        if (this.autoPackEnabled) {
            this.pack();
        }
    }

    @Override
    public void onPostInit() {
        if (this.autoPackEnabled) {
            this.pack();
        }
    }

    public void pack() {
        Rect size = FontUtils.getStringDimensions(this.text, this.getLabelPaint());
        if (size == null) {
            return;
        }
        switch (this.orientation) {
            case HORIZONTAL: {
                this.setSize(new SizeMetrics(size.height(), SizeLayoutType.ABSOLUTE, size.width() + 2, SizeLayoutType.ABSOLUTE));
                break;
            }
            case VERTICAL_ASCENDING: 
            case VERTICAL_DESCENDING: {
                this.setSize(new SizeMetrics(size.width(), SizeLayoutType.ABSOLUTE, size.height() + 2, SizeLayoutType.ABSOLUTE));
            }
        }
        this.refreshLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doOnDraw(Canvas canvas, RectF widgetRect) {
        if (this.text == null || this.text.length() == 0) {
            return;
        }
        float vOffset = this.labelPaint.getFontMetrics().descent;
        PointF start = TextLabelWidget.getAnchorCoordinates(widgetRect, AnchorPosition.CENTER);
        try {
            canvas.save(31);
            canvas.translate(start.x, start.y);
            switch (this.orientation) {
                case HORIZONTAL: {
                    break;
                }
                case VERTICAL_ASCENDING: {
                    canvas.rotate(-90.0f);
                    break;
                }
                case VERTICAL_DESCENDING: {
                    canvas.rotate(90.0f);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Orientation " + (Object)((Object)this.orientation) + " not yet implemented for TextLabelWidget.");
                }
            }
            canvas.drawText(this.text, 0.0f, vOffset, this.labelPaint);
        }
        finally {
            canvas.restore();
        }
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint labelPaint) {
        this.labelPaint = labelPaint;
        if (this.autoPackEnabled) {
            this.pack();
        }
    }

    public TextOrientationType getOrientation() {
        return this.orientation;
    }

    public void setOrientation(TextOrientationType orientation) {
        this.orientation = orientation;
        if (this.autoPackEnabled) {
            this.pack();
        }
    }

    public boolean isAutoPackEnabled() {
        return this.autoPackEnabled;
    }

    public void setAutoPackEnabled(boolean autoPackEnabled) {
        this.autoPackEnabled = autoPackEnabled;
        if (autoPackEnabled) {
            this.pack();
        }
    }

    public void setText(String text) {
        this.text = text;
        if (this.autoPackEnabled) {
            this.pack();
        }
    }

    public String getText() {
        return this.text;
    }
}

