/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.util;

import com.androidplot.util.ZIndexable;
import java.util.List;

public class ListOrganizer<ElementType>
implements ZIndexable<ElementType> {
    private List<ElementType> list;

    public ListOrganizer(List<ElementType> list) {
        this.list = list;
    }

    @Override
    public boolean moveToTop(ElementType element) {
        if (this.list.remove(element)) {
            this.list.add(this.list.size(), element);
            return true;
        }
        return false;
    }

    @Override
    public boolean moveAbove(ElementType objectToMove, ElementType reference) {
        if (objectToMove == reference) {
            throw new IllegalArgumentException("Illegal argument to moveAbove(A, B); A cannot be equal to B.");
        }
        this.list.remove(objectToMove);
        int refIndex = this.list.indexOf(reference);
        this.list.add(refIndex + 1, objectToMove);
        return true;
    }

    @Override
    public boolean moveBeneath(ElementType objectToMove, ElementType reference) {
        if (objectToMove == reference) {
            throw new IllegalArgumentException("Illegal argument to moveBeaneath(A, B); A cannot be equal to B.");
        }
        this.list.remove(objectToMove);
        int refIndex = this.list.indexOf(reference);
        this.list.add(refIndex, objectToMove);
        return true;
    }

    @Override
    public boolean moveToBottom(ElementType key) {
        this.list.remove(key);
        this.list.add(0, key);
        return true;
    }

    @Override
    public boolean moveUp(ElementType key) {
        int widgetIndex = this.list.indexOf(key);
        if (widgetIndex == -1) {
            return false;
        }
        if (widgetIndex >= this.list.size() - 1) {
            return true;
        }
        ElementType widgetAbove = this.list.get(widgetIndex + 1);
        return this.moveAbove(key, widgetAbove);
    }

    @Override
    public boolean moveDown(ElementType key) {
        int widgetIndex = this.list.indexOf(key);
        if (widgetIndex == -1) {
            return false;
        }
        if (widgetIndex <= 0) {
            return true;
        }
        ElementType widgetBeneath = this.list.get(widgetIndex - 1);
        return this.moveBeneath(key, widgetBeneath);
    }

    @Override
    public List<ElementType> elements() {
        return this.list;
    }

    public void addToBottom(ElementType element) {
        this.list.add(0, element);
    }

    public void addToTop(ElementType element) {
        this.list.add(this.list.size(), element);
    }
}

