/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.util;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PixelUtils {
    private static DisplayMetrics metrics;
    private static final float FLOAT_INT_AVG_NUDGE = 0.5f;
    public static final Map<String, Integer> dimensionConstantLookup;
    private static final Pattern DIMENSION_PATTERN;

    public static void init(Context ctx) {
        metrics = ctx.getResources().getDisplayMetrics();
    }

    public static PointF add(PointF lhs, PointF rhs) {
        return new PointF(lhs.x + rhs.x, lhs.y + rhs.y);
    }

    public static PointF sub(PointF lhs, PointF rhs) {
        return new PointF(lhs.x - rhs.x, lhs.y - rhs.y);
    }

    public static RectF sink(RectF in) {
        return PixelUtils.nearestPixRect(in.left, in.top, in.right, in.bottom);
    }

    public static RectF nearestPixRect(float left, float top, float right, float bottom) {
        return new RectF((float)((int)(left + 0.5f)), (float)((int)(top + 0.5f)), (float)((int)(right + 0.5f)), (float)((int)(bottom + 0.5f)));
    }

    public static float dpToPix(float dp) {
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)metrics);
    }

    public static float spToPix(float sp) {
        return TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)metrics);
    }

    public static float fractionToPixH(float fraction) {
        return (float)PixelUtils.metrics.heightPixels * fraction;
    }

    public static float fractionToPixW(float fraction) {
        return (float)PixelUtils.metrics.widthPixels * fraction;
    }

    private static Map<String, Integer> initDimensionConstantLookup() {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("px", 0);
        m.put("dip", 1);
        m.put("dp", 1);
        m.put("sp", 2);
        m.put("pt", 3);
        m.put("in", 4);
        m.put("mm", 5);
        return Collections.unmodifiableMap(m);
    }

    public static float stringToDimension(String dimension) {
        InternalDimension internalDimension = PixelUtils.stringToInternalDimension(dimension);
        return TypedValue.applyDimension((int)internalDimension.unit, (float)internalDimension.value, (DisplayMetrics)metrics);
    }

    private static InternalDimension stringToInternalDimension(String dimension) {
        Matcher matcher = DIMENSION_PATTERN.matcher(dimension);
        if (matcher.matches()) {
            float value = Float.valueOf(matcher.group(1)).floatValue();
            String unit = matcher.group(3).toLowerCase();
            Integer dimensionUnit = dimensionConstantLookup.get(unit);
            if (dimensionUnit == null) {
                throw new NumberFormatException();
            }
            return new InternalDimension(value, dimensionUnit);
        }
        throw new NumberFormatException();
    }

    static {
        dimensionConstantLookup = PixelUtils.initDimensionConstantLookup();
        DIMENSION_PATTERN = Pattern.compile("^\\s*(\\d+(\\.\\d+)*)\\s*([a-zA-Z]+)\\s*$");
    }

    private static class InternalDimension {
        float value;
        int unit;

        public InternalDimension(float value, int unit) {
            this.value = value;
            this.unit = unit;
        }
    }
}

