/*
 * Decompiled with CFR 0.152.
 */
package com.androidplot.xy;

import android.graphics.Paint;
import com.androidplot.ui.SeriesRenderer;
import com.androidplot.xy.BarRenderer;
import com.androidplot.xy.LineAndPointFormatter;
import com.androidplot.xy.XYPlot;

public class BarFormatter
extends LineAndPointFormatter {
    private Paint fillPaint = new Paint();
    private Paint borderPaint;

    @Override
    public Paint getFillPaint() {
        return this.fillPaint;
    }

    @Override
    public void setFillPaint(Paint fillPaint) {
        this.fillPaint = fillPaint;
    }

    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public void setBorderPaint(Paint borderPaint) {
        this.borderPaint = borderPaint;
    }

    public BarFormatter() {
        this.fillPaint.setStyle(Paint.Style.FILL);
        this.fillPaint.setAlpha(100);
        this.borderPaint = new Paint();
        this.borderPaint.setStyle(Paint.Style.STROKE);
        this.borderPaint.setAlpha(100);
    }

    public BarFormatter(int fillColor, int borderColor) {
        this.fillPaint.setStyle(Paint.Style.FILL);
        this.fillPaint.setAlpha(100);
        this.borderPaint = new Paint();
        this.borderPaint.setStyle(Paint.Style.STROKE);
        this.borderPaint.setAlpha(100);
        this.fillPaint.setColor(fillColor);
        this.borderPaint.setColor(borderColor);
    }

    @Override
    public Class<? extends SeriesRenderer> getRendererClass() {
        return BarRenderer.class;
    }

    @Override
    public SeriesRenderer getRendererInstance(XYPlot plot) {
        return new BarRenderer(plot);
    }
}

