/*
 * Decompiled with CFR 0.152.
 */
package com.appscode.api.apprc;

import com.appscode.api.apprc.Apprc;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApprcHolder {
    private static final String apprcFile = System.getProperty("user.home") + "/.appscode/apprc.json";
    private static final Logger logger = Logger.getLogger(ApprcHolder.class.getName());

    private ApprcHolder() {
    }

    public static Apprc get() {
        return LazyHolder.instance;
    }

    private static Apprc readUserApprc() {
        try {
            return ApprcHolder.readUserApprc(apprcFile);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("No files to read system apprc");
        }
    }

    public static Apprc readUserApprc(String apprcFileURI) throws FileNotFoundException {
        return ApprcHolder.readUserApprc(new FileReader(Paths.get(apprcFileURI, new String[0]).toFile()));
    }

    public static Apprc readUserApprc(Reader reader) {
        return ApprcHolder.read(reader, new JsonFactory());
    }

    private static Apprc read(Reader reader, JsonFactory factory) {
        ObjectMapper mapper = new ObjectMapper(factory);
        logger.log(Level.INFO, "reading file type " + factory.getClass().getSimpleName());
        try {
            return (Apprc)mapper.readValue(reader, Apprc.class);
        }
        catch (IOException e) {
            logger.info("exception parsing file");
            throw Throwables.propagate((Throwable)e);
        }
    }

    static /* synthetic */ Apprc access$100() {
        return ApprcHolder.readUserApprc();
    }

    private static class LazyHolder {
        private static final Apprc instance = ApprcHolder.access$100();

        private LazyHolder() {
        }
    }
}

