/*
 * Decompiled with CFR 0.152.
 */
package com.appscode.api.apprc;

import com.appscode.api.apprc.Environment;
import com.appscode.api.apprc.Network;
import com.appscode.api.apprc.Setting;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class Auth {
    @JsonProperty(value="env")
    private String environment;
    @JsonProperty(value="team_id")
    private String teamId;
    private String apiserver;
    private String username;
    private String email;
    private String token;
    private String phid;
    private Setting setttings;
    private Network network;

    public Auth() {
    }

    public Auth(String apiserver, String environment, String teamId, String username, String email, String token, String phid, Setting setttings, Network network) {
        this.apiserver = apiserver;
        this.environment = environment;
        this.teamId = teamId;
        this.username = username;
        this.email = email;
        this.token = token;
        this.phid = phid;
        this.setttings = setttings;
        this.network = network;
    }

    public String getApiserver() {
        return this.apiserver;
    }

    public void setApiserver(String apiserver) {
        this.apiserver = apiserver;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getTeamId() {
        return this.teamId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getPhid() {
        return this.phid;
    }

    public void setPhid(String phid) {
        this.phid = phid;
    }

    public Setting getSetttings() {
        return this.setttings;
    }

    public void setSetttings(Setting setttings) {
        this.setttings = setttings;
    }

    public Network getNetwork() {
        return this.network;
    }

    public void setNetwork(Network network) {
        this.network = network;
    }

    public String getTeamAddress() {
        if (Environment.get().equals("onebox") || Environment.get().equals("boxdev")) {
            return this.getNetwork().getTeamUrls().getBaseAddr();
        }
        return this.getTeamId() + "." + this.getNetwork().getTeamUrls().getBaseAddr();
    }

    public String getTeamURL(String ... trails) {
        return this.getTeamEndpoint() + "/" + String.join((CharSequence)"/", trails) + "/";
    }

    public String getTeamEndpoint() {
        return this.getNetwork().getTeamUrls().getScheme() + "://" + this.getTeamAddress();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Auth auth = (Auth)o;
        return Objects.equals(this.apiserver, auth.apiserver) && Objects.equals(this.environment, auth.environment) && Objects.equals(this.teamId, auth.teamId) && Objects.equals(this.username, auth.username) && Objects.equals(this.email, auth.email) && Objects.equals(this.token, auth.token) && Objects.equals(this.phid, auth.phid) && Objects.equals(this.setttings, auth.setttings) && Objects.equals(this.network, auth.network);
    }

    public int hashCode() {
        return Objects.hash(this.apiserver, this.teamId, this.username);
    }

    public String toString() {
        return "Auth{apiserver='" + this.apiserver + '\'' + ", environment='" + this.environment + '\'' + ", teamId='" + this.teamId + '\'' + ", username='" + this.username + '\'' + ", email='" + this.email + '\'' + ", token='" + this.token + '\'' + ", phid='" + this.phid + '\'' + ", setttings=" + this.setttings + ", network=" + this.network + '}';
    }
}

