/*
 * Decompiled with CFR 0.152.
 */
package com.assemblade.client;

import com.assemblade.client.AbstractClient;
import com.assemblade.client.ClientException;
import com.assemblade.client.model.Authentication;
import com.assemblade.client.model.Group;
import com.assemblade.client.model.GroupMember;
import com.assemblade.client.model.User;
import java.util.List;
import org.codehaus.jackson.type.TypeReference;

public class Groups
extends AbstractClient {
    public Groups(Authentication authentication) {
        super(authentication);
    }

    public Group getGroup(String url) throws ClientException {
        return this.getFromUrl(url, new TypeReference<Group>(){});
    }

    public List<Group> getAllGroups() throws ClientException {
        return this.get("/groups", new TypeReference<List<Group>>(){});
    }

    public Group getAdministratorGroup() throws ClientException {
        return this.get("/groups/administrator", new TypeReference<Group>(){});
    }

    public List<GroupMember> getGroupMembers(Group group) throws ClientException {
        return this.get("/groups/id/" + group.getId() + "/members", new TypeReference<List<GroupMember>>(){});
    }

    public GroupMember addMemberToGroup(GroupMember groupMember) throws ClientException {
        return this.add("/groups/id/" + groupMember.getGroup().getId() + "/members", groupMember, new TypeReference<GroupMember>(){});
    }

    public GroupMember editGroupMember(GroupMember groupMember) throws ClientException {
        return this.update("/groups/id/" + groupMember.getGroup().getId() + "/members/id/" + groupMember.getId(), groupMember, new TypeReference<GroupMember>(){});
    }

    public void removeMemberFromGroup(GroupMember groupMember) throws ClientException {
        this.delete("/groups/id/" + groupMember.getGroup().getId() + "/members/id/" + groupMember.getId());
    }

    public List<User> getNonGroupMembers(Group group) throws ClientException {
        return this.get("/groups/id/" + group.getId() + "/nonmembers", new TypeReference<List<User>>(){});
    }

    public Group addGroup(Group group) throws ClientException {
        return this.add("/groups", group, new TypeReference<Group>(){});
    }

    public Group updateGroup(Group group) throws ClientException {
        return this.update("/groups/id/" + group.getId(), group, new TypeReference<Group>(){});
    }

    public void deleteGroup(Group group) throws ClientException {
        this.delete("/groups/id/" + group.getId());
    }
}

