/*
 * Decompiled with CFR 0.152.
 */
package com.assemblade.client;

import com.assemblade.client.AbstractClient;
import com.assemblade.client.CallFailedException;
import com.assemblade.client.ClientException;
import com.assemblade.client.model.Authentication;
import com.assemblade.client.model.Property;
import com.assemblade.client.model.View;
import java.util.BitSet;
import java.util.List;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.codehaus.jackson.type.TypeReference;

public class Views
extends AbstractClient {
    public Views(Authentication authentication) {
        super(authentication);
    }

    public View getView(String url) throws ClientException {
        return this.getFromUrl(url, new TypeReference<View>(){});
    }

    public View getViewByName(String name) throws ClientException {
        try {
            return this.get("/views/name/" + URIUtil.encode((String)name, (BitSet)URI.allowed_fragment), new TypeReference<View>(){});
        }
        catch (URIException e) {
            throw new CallFailedException("Failed to encode request path", e);
        }
    }

    public List<View> getViews() throws ClientException {
        return this.get("/views", new TypeReference<List<View>>(){});
    }

    public List<Property> getProperties(View view) throws ClientException {
        return this.get("/views/id/" + view.getId() + "/properties", new TypeReference<List<Property>>(){});
    }

    public View addView(View view) throws ClientException {
        return this.add("/views", view, new TypeReference<View>(){});
    }

    public View updateView(View view) throws ClientException {
        return this.update("/views/id/" + view.getId(), view, new TypeReference<View>(){});
    }

    public void deleteView(View view) throws ClientException {
        this.delete("/views/id/" + view.getId());
    }
}

