/*
 * Decompiled with CFR 0.152.
 */
package com.assemblade.client;

import com.assemblade.client.AbstractClient;
import com.assemblade.client.ClientException;
import com.assemblade.client.model.Authentication;
import com.assemblade.client.model.Folder;
import java.util.List;
import org.codehaus.jackson.type.TypeReference;

public class Folders
extends AbstractClient {
    public Folders(Authentication authentication) {
        super(authentication);
    }

    public Folder getFolder(String url) throws ClientException {
        return this.getFromUrl(url, new TypeReference<Folder>(){});
    }

    public List<Folder> getRootFolders() throws ClientException {
        return this.get("/folders", new TypeReference<List<Folder>>(){});
    }

    public List<Folder> getChildFolders(Folder parent) throws ClientException {
        return this.get("/folders/id/" + parent.getId() + "/folders", new TypeReference<List<Folder>>(){});
    }

    public Folder addRootFolder(Folder folder) throws ClientException {
        return this.add("/folders", folder, new TypeReference<Folder>(){});
    }

    public Folder addChildFolder(Folder parent, Folder folder) throws ClientException {
        return this.add("/folders/id/" + parent.getId(), folder, new TypeReference<Folder>(){});
    }

    public Folder updateFolder(Folder folder) throws ClientException {
        return this.update("/folders/id/" + folder.getId(), folder, new TypeReference<Folder>(){});
    }

    public void deleteFolder(Folder folder) throws ClientException {
        this.delete("/folders/id/" + folder.getId());
    }
}

