/*
 * Decompiled with CFR 0.152.
 */
package com.assemblade.client;

import com.assemblade.client.AbstractClient;
import com.assemblade.client.ClientException;
import com.assemblade.client.model.Authentication;
import com.assemblade.client.model.User;
import java.util.List;
import org.codehaus.jackson.type.TypeReference;

public class Users
extends AbstractClient {
    public Users(Authentication authentication) {
        super(authentication);
    }

    public User getUser(String url) throws ClientException {
        return this.getFromUrl(url, new TypeReference<User>(){});
    }

    public List<User> getUsers() throws ClientException {
        return this.get("/users", new TypeReference<List<User>>(){});
    }

    public User getAuthenticatedUser() throws ClientException {
        return this.get("/users/current", new TypeReference<User>(){});
    }

    public User addUser(User user) throws ClientException {
        return this.add("/users", user, new TypeReference<User>(){});
    }

    public User updateUser(User user) throws ClientException {
        return this.update("/users/id/" + user.getId(), user, new TypeReference<User>(){});
    }

    public void deleteUser(User user) throws ClientException {
        this.delete("/users/id/" + user.getId());
    }
}

