/*
 * Decompiled with CFR 0.152.
 */
package com.barbarysoftware.linkifier;

import com.barbarysoftware.linkifier.Link;
import com.barbarysoftware.linkifier.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Linkifier {
    private static final Pattern REGEX_URL_PATTERN = Pattern.compile("(https?://)?([a-z0-9-@]+\\.)+(" + Linkifier.getTLDs() + ")+(/([-a-zA-Z0-9@:%._+~#?&/=;()!$*])*)?+(\\?([-a-zA-Z0-9@:%._+~#?&/=;()!$*])*)?", 2);
    private final boolean useHttps;
    private final boolean openLinksInNewWindow;

    public Linkifier() {
        this(false, false);
    }

    public Linkifier(boolean useHttps, boolean openLinksInNewWindow) {
        this.useHttps = useHttps;
        this.openLinksInNewWindow = openLinksInNewWindow;
    }

    public String linkify(String input) {
        Objects.requireNonNull(input);
        List<Link> links = this.findUrls(input);
        return this.convertLinks(input, links);
    }

    private String convertLinks(String input, List<Link> links) {
        StringBuilder sb = new StringBuilder();
        int nextStart = 0;
        for (Link link : links) {
            sb.append(input, nextStart, link.start());
            sb.append(this.toLinkTag(link));
            nextStart = link.end();
        }
        sb.append(input, nextStart, input.length());
        return sb.toString();
    }

    private String toLinkTag(Link link) {
        if (this.openLinksInNewWindow) {
            return "<a href='" + link.href() + "'>" + link.value() + "</a>";
        }
        return "<a href='" + link.href() + "' target='_blank'>" + link.value() + "</a>";
    }

    private List<Link> findUrls(String input) {
        ArrayList<Link> result = new ArrayList<Link>();
        Matcher matcher = REGEX_URL_PATTERN.matcher(input);
        while (matcher.find()) {
            if (matcher.group().contains("@")) continue;
            String href = this.toHref(matcher.group());
            result.add(new Link(matcher.group(), href, matcher.start(), matcher.end()));
        }
        return result;
    }

    private String toHref(String matchedString) {
        if (Util.startsWithIgnoreCase(matchedString, "http://") || Util.startsWithIgnoreCase(matchedString, "https://")) {
            return matchedString;
        }
        if (this.useHttps) {
            return "https://" + matchedString;
        }
        return "http://" + matchedString;
    }

    private static String getTLDs() {
        return Stream.of("com", "org", "net", "edu", "gov", "io", "info", "top", "academy", "af", "ax", "al", "dz", "as", "ad", "ao", "ai", "aq", "ag", "ar", "am", "aw", "ac", "au", "at", "az", "bs", "bh", "bd", "bb", "eus", "by", "be", "bz", "bj", "bm", "bt", "bo", "bq", "an", "nl", "ba", "bw", "bv", "br", "io", "vg", "bn", "bg", "bf", "mm", "bi", "kh", "cm", "ca", "cv", "cat", "ky", "cw", "cy", "cz", "dk", "dj", "dm", "do", "tl", "tp", "ec", "eg", "sv", "gq", "er", "ee", "et", "eu", "fk", "fo", "fm", "fj", "fi", "fr", "gf", "pf", "tf", "ga", "gal", "gm", "ps", "ge", "de", "gh", "gi", "gr", "gl", "gd", "gp", "gu", "gt", "gg", "gn", "gw", "gy", "ht", "hm", "hn", "hk", "hu", "is", "in", "id", "ir", "iq", "ie", "im", "il", "it", "jm", "jp", "je", "jo", "kz", "ke", "ki", "kw", "kg", "la", "lv", "lb", "ls", "lr", "ly", "li", "lt", "lu", "mo", "mk", "mg", "mw", "my", "mv", "ml", "mt", "mh", "mq", "mr", "mu", "yt", "mx", "md", "mc", "mn", "me", "ms", "ma", "mz", "mm", "na", "nr", "np", "nl", "nc", "nz", "ni", "ne", "ng", "nu", "nf", "nc", "tr", "kp", "mp", "no", "om", "pk", "pw", "ps", "pa", "pg", "py", "pe", "ph", "pn", "pl", "pt", "pr", "qa", "ro", "ru", "rw", "re", "bq", "an", "bl", "gp", "fr", "sh", "kn", "lc", "mf", "gp", "fr", "pm", "vc", "ws", "sm", "st", "sa", "sn", "rs", "sc", "sl", "sg", "bq", "an", "nl", "sx", "an", "sk", "si", "sb", "so", "so", "za", "gs", "kr", "ss", "es", "lk", "sd", "sr", "sj", "sz", "se", "ch", "sy", "tw", "tj", "tz", "th", "tg", "tk", "to", "tt", "tn", "tr", "tm", "tc", "tv", "ug", "ua", "cf", "td", "cl", "cn", "cx", "cc", "co", "km", "cd", "cg", "ck", "cr", "ci", "hr", "cu", "ae", "uk", "us", "vi", "uy", "uz", "vu", "va", "ve", "vn", "wf", "eh", "ma", "ye", "zm", "zw").map(tld -> "\\b" + tld + "\\b").collect(Collectors.joining("|"));
    }
}

