/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.simplegraph.github;

import com.bitplan.simplegraph.core.SimpleNode;
import com.bitplan.simplegraph.core.SimpleSystem;
import com.bitplan.simplegraph.impl.PropertiesImpl;
import com.bitplan.simplegraph.impl.SimpleSystemImpl;
import com.bitplan.simplegraph.json.JsonNode;
import com.bitplan.simplegraph.json.JsonSystem;
import java.io.File;
import java.util.logging.Level;

public class GitHubSystem
extends SimpleSystemImpl {
    private static final String GITHUB_APIV4 = "https://api.github.com/graphql";
    JsonSystem js;
    static boolean first = true;

    public JsonSystem getGitHubJsonSystem() throws Exception {
        PropertiesImpl properties = new PropertiesImpl("github");
        String token = (String)properties.getProperty("oauth");
        JsonSystem js = new JsonSystem();
        js.setDebug(this.debug);
        js.connect(new String[]{"Authorization: bearer " + token});
        return js;
    }

    public SimpleSystem connect(String ... connectionParams) throws Exception {
        this.js = this.getGitHubJsonSystem();
        return this;
    }

    public SimpleNode moveTo(String nodeQuery, String ... keys) {
        SimpleNode result = null;
        if ("".equals(nodeQuery)) {
            result = this.js.moveTo(GITHUB_APIV4, new String[0]);
        } else {
            String queryJson = String.format("{ \"query\": \"%s\" }", nodeQuery.replaceAll("\"", "\\\\\"").replaceAll("\n", ""));
            if (this.debug) {
                LOGGER.log(Level.INFO, queryJson);
            }
            result = this.js.post(GITHUB_APIV4, queryJson);
        }
        this.optionalStartNode(result);
        return result;
    }

    public Class<? extends SimpleNode> getNodeClass() {
        return JsonNode.class;
    }

    public static boolean hasAuthentication() {
        File authFile = PropertiesImpl.getPropertyFile((String)"github");
        boolean result = authFile.canRead();
        if (first && !result) {
            first = false;
            LOGGER.log(Level.WARNING, String.format("To use the github System you might want to create the file %s with an entry oauth=<token>\nThe token can be obtained from https://github.com/settings/tokens", authFile.getAbsolutePath()));
        }
        return result;
    }
}

