/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.simplegraph.github;

import com.bitplan.simplegraph.core.SimpleNode;
import com.bitplan.simplegraph.core.SimpleSystem;
import com.bitplan.simplegraph.impl.SimpleSystemImpl;
import com.bitplan.simplegraph.json.JsonNode;
import com.bitplan.simplegraph.json.JsonSystem;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.logging.Level;

public class GitHubSystem
extends SimpleSystemImpl {
    private static final String GITHUB_APIV4 = "https://api.github.com/graphql";
    JsonSystem js;
    static boolean first = true;

    public static File getAuthFile() {
        String home = System.getProperty("user.home");
        return new File(home + "/.github/access_token.json");
    }

    public JsonSystem getGitHubJsonSystem() throws Exception {
        File authFile = GitHubSystem.getAuthFile();
        if (!authFile.exists()) {
            throw new IllegalStateException("GitHub authentication file not found at " + authFile.getAbsolutePath());
        }
        String jsonContent = new String(Files.readAllBytes(Paths.get(authFile.toURI())));
        JsonSystem authJs = JsonSystem.of(null, (String)jsonContent);
        SimpleNode authNode = authJs.getStartNode();
        String token = (String)authNode.getMap().get("access_token");
        if (token == null || token.trim().isEmpty()) {
            throw new IllegalStateException("access_token not found in " + authFile.getAbsolutePath());
        }
        JsonSystem js = new JsonSystem();
        js.setDebug(this.debug);
        js.connect(new String[]{"Authorization: bearer " + token});
        return js;
    }

    public SimpleSystem connect(String ... connectionParams) throws Exception {
        this.js = this.getGitHubJsonSystem();
        return this;
    }

    public SimpleNode moveTo(String nodeQuery, String ... keys) {
        SimpleNode result = null;
        if ("".equals(nodeQuery)) {
            result = this.js.moveTo(GITHUB_APIV4, new String[0]);
        } else {
            String queryJson = String.format("{ \"query\": \"%s\" }", nodeQuery.replaceAll("\"", "\\\\\"").replaceAll("\n", ""));
            if (this.debug) {
                LOGGER.log(Level.INFO, queryJson);
            }
            result = this.js.post(GITHUB_APIV4, queryJson);
        }
        this.optionalStartNode(result);
        return result;
    }

    public Class<? extends SimpleNode> getNodeClass() {
        return JsonNode.class;
    }

    public static boolean hasAuthentication() {
        File authFile = GitHubSystem.getAuthFile();
        boolean result = authFile.canRead();
        if (first && !result) {
            first = false;
            LOGGER.log(Level.WARNING, String.format("To use the github System you might want to create the file %s with the content {\"access_token\": \"<github_pat_...>\"} \nThe token can be obtained from https://github.com/settings/tokens", authFile.getAbsolutePath()));
        }
        return result;
    }
}

