/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.simplegraph.sql;

import com.bitplan.simplegraph.core.SimpleGraph;
import com.bitplan.simplegraph.core.SimpleNode;
import com.bitplan.simplegraph.core.SimpleSystem;
import com.bitplan.simplegraph.impl.SimpleSystemImpl;
import com.bitplan.simplegraph.sql.SQLRecord;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class SQLSystem
extends SimpleSystemImpl {
    String driver;
    String connection;
    String user;
    String password;
    String defaultKind = "row";
    private Connection dbConnection;

    public SQLSystem(SimpleGraph graph) {
        super(graph);
    }

    public SQLSystem() {
    }

    public void setDefaultKind(String kind) {
        this.defaultKind = kind;
    }

    public Connection getDBConnection() {
        return this.dbConnection;
    }

    public SimpleSystem connect(String ... connectionParams) throws Exception {
        if (connectionParams.length > 0) {
            this.driver = connectionParams[0];
        }
        if (connectionParams.length > 1) {
            this.connection = connectionParams[1];
        }
        if (connectionParams.length > 2) {
            this.user = connectionParams[2];
        }
        if (connectionParams.length > 3) {
            this.password = connectionParams[3];
        }
        Class.forName(this.driver);
        this.dbConnection = DriverManager.getConnection(this.connection, this.user, this.password);
        return this;
    }

    public SimpleNode moveTo(String nodeQuery, String ... keys) {
        SQLRecord sqlRecord = null;
        try {
            this.dbConnection.setAutoCommit(false);
            Statement stmt = this.dbConnection.createStatement();
            ResultSet rs = stmt.executeQuery(nodeQuery);
            ResultSetMetaData rsMetaData = rs.getMetaData();
            String kind = rsMetaData.getTableName(1);
            if (kind == null || kind.trim().isEmpty()) {
                kind = this.defaultKind;
            }
            while (rs.next()) {
                sqlRecord = new SQLRecord((SimpleGraph)this, kind, rs, rsMetaData);
                if (this.getStartNode() != null) continue;
                this.setStartNode((SimpleNode)sqlRecord);
            }
            stmt.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return sqlRecord;
    }

    public Class<? extends SimpleNode> getNodeClass() {
        return SQLRecord.class;
    }

    public void execute(String sqlScript) throws SQLException {
        String[] sqlLines;
        this.dbConnection.setAutoCommit(false);
        Statement stmt = this.dbConnection.createStatement();
        String[] stringArray = sqlLines = sqlScript.split("\n");
        int n = sqlLines.length;
        int n2 = 0;
        while (n2 < n) {
            String sqlLine = stringArray[n2];
            stmt.execute(sqlLine);
            ++n2;
        }
        stmt.close();
        this.dbConnection.commit();
    }

    public SimpleSystem close(String ... closeParams) throws Exception {
        if (this.dbConnection != null && !this.dbConnection.isClosed()) {
            this.dbConnection.close();
        }
        super.close(closeParams);
        return this;
    }
}

