/*
 * Decompiled with CFR 0.152.
 */
package com.browserstack.local;

import com.browserstack.local.LocalBinary;
import com.browserstack.local.LocalException;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class Local {
    List<String> command;
    Map<String, String> startOptions;
    String binaryPath;
    String logFilePath;
    int pid = 0;
    private Process proc = null;
    private final Map<String, String> parameters = new HashMap<String, String>();

    public Local() {
        this.parameters.put("v", "-vvv");
        this.parameters.put("f", "-f");
        this.parameters.put("force", "-force");
        this.parameters.put("only", "-only");
        this.parameters.put("forcelocal", "-forcelocal");
        this.parameters.put("localIdentifier", "-localIdentifier");
        this.parameters.put("onlyAutomate", "-onlyAutomate");
        this.parameters.put("proxyHost", "-proxyHost");
        this.parameters.put("proxyPort", "-proxyPort");
        this.parameters.put("proxyUser", "-proxyUser");
        this.parameters.put("proxyPass", "-proxyPass");
        this.parameters.put("forceproxy", "-forceproxy");
        this.parameters.put("hosts", "-hosts");
    }

    public void start(Map<String, String> options) throws Exception {
        this.startOptions = options;
        if (options.get("binarypath") != null) {
            this.binaryPath = options.get("binarypath");
        } else {
            LocalBinary lb = new LocalBinary();
            this.binaryPath = lb.getBinaryPath();
        }
        this.logFilePath = options.get("logfile") == null ? System.getProperty("user.dir") + "/local.log" : options.get("logfile");
        this.makeCommand(options, "start");
        if (options.get("onlyCommand") != null) {
            return;
        }
        if (this.proc == null) {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder(this.command);
            FileWriter fw = new FileWriter(this.logFilePath);
            fw.write("");
            fw.close();
            this.proc = processBuilder.start();
            BufferedReader stdoutbr = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
            BufferedReader stderrbr = new BufferedReader(new InputStreamReader(this.proc.getErrorStream()));
            String stdout = "";
            String stderr = "";
            while ((line = stdoutbr.readLine()) != null) {
                stdout = stdout + line;
            }
            while ((line = stderrbr.readLine()) != null) {
                stderr = stderr + line;
            }
            int r = this.proc.waitFor();
            JSONObject obj = new JSONObject(stdout != "" ? stdout : stderr);
            if (!obj.getString("state").equals("connected")) {
                throw new LocalException(obj.getString("message"));
            }
            this.pid = obj.getInt("pid");
        }
    }

    public void stop() throws Exception {
        if (this.pid != 0) {
            this.makeCommand(this.startOptions, "stop");
            ProcessBuilder processBuilder = new ProcessBuilder(this.command);
            this.proc = processBuilder.start();
            this.proc.waitFor();
            this.pid = 0;
        }
    }

    public boolean isRunning() throws Exception {
        if (this.pid == 0) {
            return false;
        }
        return this.isProcessRunning(this.pid);
    }

    private void makeCommand(Map<String, String> options, String opCode) {
        this.command = new ArrayList<String>();
        this.command.add(this.binaryPath);
        this.command.add("-d");
        this.command.add(opCode);
        this.command.add("-logFile");
        this.command.add(this.logFilePath);
        this.command.add(options.get("key"));
        for (Map.Entry<String, String> opt : options.entrySet()) {
            String parameter;
            List<String> ignoreKeys = Arrays.asList("key", "logfile", "binarypath");
            if (ignoreKeys.contains(parameter = opt.getKey().trim())) continue;
            if (this.parameters.get(parameter) != null) {
                this.command.add(this.parameters.get(parameter));
            } else {
                this.command.add("-" + parameter);
            }
            if (opt.getValue() == null) continue;
            this.command.add(opt.getValue().trim());
        }
    }

    private boolean isProcessRunning(int pid) throws Exception {
        ArrayList<String> cmd = new ArrayList<String>();
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            cmd.add("cmd");
            cmd.add("/c");
            cmd.add("\"tasklist /FI \"PID eq " + pid + "\" | findstr " + pid + "\"");
        } else {
            cmd.add("ps");
            cmd.add("-p");
            cmd.add(String.valueOf(pid));
        }
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        this.proc = processBuilder.start();
        int exitValue = this.proc.waitFor();
        return exitValue == 0;
    }
}

